/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.central.security.service;

import java.util.HashMap;
import net.solarnetwork.central.biz.UserEventAppenderBiz;
import net.solarnetwork.central.domain.LogEventInfo;
import net.solarnetwork.central.security.SecurityActor;
import net.solarnetwork.central.security.SecurityException;
import net.solarnetwork.central.security.SecurityToken;
import net.solarnetwork.central.security.SecurityUser;
import net.solarnetwork.central.security.SecurityUtils;
import net.solarnetwork.central.support.EventDetailsProvider;
import net.solarnetwork.codec.JsonUtils;
import net.solarnetwork.util.ObjectUtils;
import org.springframework.context.event.EventListener;
import org.springframework.security.authentication.event.AbstractAuthenticationEvent;
import org.springframework.security.authentication.event.AbstractAuthenticationFailureEvent;
import org.springframework.security.authentication.event.AuthenticationSuccessEvent;
import org.springframework.security.authentication.event.LogoutSuccessEvent;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.authentication.WebAuthenticationDetails;

public class AuthenticationUserEventPublisher {
    private static final String[] AUTH_SUCCESS_TAGS = new String[]{"security", "auth", "success"};
    private static final String[] AUTH_LOGOUT_TAGS = new String[]{"security", "auth", "logout"};
    private static final String[] AUTH_FAILURE_TAGS = new String[]{"security", "auth", "failure"};
    private final UserEventAppenderBiz userEventAppenderBiz;
    private boolean failureOnly;
    private final String[] authSuccessTags;
    private final String[] authLogoutTags;
    private final String[] authFailureTags;

    public AuthenticationUserEventPublisher(String context, UserEventAppenderBiz userEventAppenderBiz) {
        ObjectUtils.requireNonNullArgument((Object)context, (String)"context");
        this.userEventAppenderBiz = (UserEventAppenderBiz)ObjectUtils.requireNonNullArgument((Object)userEventAppenderBiz, (String)"userEventAppenderBiz");
        this.authSuccessTags = AuthenticationUserEventPublisher.setupTags(context, AUTH_SUCCESS_TAGS);
        this.authLogoutTags = AuthenticationUserEventPublisher.setupTags(context, AUTH_LOGOUT_TAGS);
        this.authFailureTags = AuthenticationUserEventPublisher.setupTags(context, AUTH_FAILURE_TAGS);
    }

    private static final String[] setupTags(String context, String[] src) {
        String[] dest = new String[src.length + 1];
        dest[0] = context;
        System.arraycopy(src, 0, dest, 1, src.length);
        return dest;
    }

    @EventListener(value={AbstractAuthenticationEvent.class})
    public void processAuthenticationEvent(AbstractAuthenticationEvent event) {
        Object p;
        String[] tags;
        String message = null;
        HashMap<String, Object> data = null;
        if (event instanceof AuthenticationSuccessEvent) {
            if (this.failureOnly) {
                return;
            }
            tags = this.authSuccessTags;
        } else if (event instanceof LogoutSuccessEvent) {
            if (this.failureOnly) {
                return;
            }
            tags = this.authLogoutTags;
        } else if (event instanceof AbstractAuthenticationFailureEvent) {
            AbstractAuthenticationFailureEvent fe = (AbstractAuthenticationFailureEvent)event;
            tags = this.authFailureTags;
            message = ((Object)((Object)fe.getException())).getClass().getSimpleName();
            data = new HashMap<String, Object>(2);
            data.put("error", fe.getException().getMessage());
        } else {
            return;
        }
        Long userId = null;
        Authentication auth = event.getAuthentication();
        try {
            userId = SecurityUtils.getActorUserId(auth);
        }
        catch (SecurityException e2) {
            return;
        }
        if (data == null) {
            data = new HashMap(4);
        }
        if (auth instanceof EventDetailsProvider) {
            EventDetailsProvider p2 = (EventDetailsProvider)auth;
            data.putAll(p2.eventDetails());
        } else {
            Object object = auth.getDetails();
            if (object instanceof EventDetailsProvider) {
                p = (EventDetailsProvider)object;
                data.putAll(p.eventDetails());
            }
        }
        data.put("prinicpal", auth.getPrincipal());
        p = auth.getDetails();
        if (p instanceof WebAuthenticationDetails) {
            WebAuthenticationDetails w = (WebAuthenticationDetails)p;
            data.put("remoteAddress", w.getRemoteAddress());
        }
        try {
            SecurityActor actor = SecurityUtils.getActor(auth);
            if (actor instanceof SecurityUser) {
                SecurityUser user = (SecurityUser)actor;
                data.put("email", user.getEmail());
            } else if (actor instanceof SecurityToken) {
                SecurityToken tok = (SecurityToken)actor;
                data.put("token", tok.getToken());
            }
        }
        catch (SecurityException actor) {
            // empty catch block
        }
        if (auth.getAuthorities() != null && !auth.getAuthorities().isEmpty()) {
            data.put("roles", auth.getAuthorities().stream().map(e -> e.getAuthority()).toArray(String[]::new));
        }
        LogEventInfo info = new LogEventInfo(tags, message, JsonUtils.getJSONString(data, null));
        this.userEventAppenderBiz.addEvent(userId, info);
    }

    public boolean isFailureOnly() {
        return this.failureOnly;
    }

    public void setFailureOnly(boolean failureOnly) {
        this.failureOnly = failureOnly;
    }
}

