/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.central.security.jdbc;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.solarnetwork.central.security.AuthenticatedToken;
import net.solarnetwork.central.security.AuthenticatedUser;
import net.solarnetwork.central.security.BasicSecurityPolicy;
import net.solarnetwork.central.security.SecurityPolicy;
import net.solarnetwork.central.security.SecurityTokenType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.jdbc.JdbcDaoImpl;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

public class JdbcUserDetailsService
extends JdbcDaoImpl
implements UserDetailsService {
    public static final String DEFAULT_USERS_BY_USERNAME_SQL = "SELECT username, password, enabled, user_id, display_name, FALSE AS is_token FROM solaruser.user_login WHERE username = ?";
    public static final String DEFAULT_AUTHORITIES_BY_USERNAME_SQL = "SELECT username, authority FROM solaruser.user_login_role WHERE username = ?";
    public static final String DEFAULT_TOKEN_USERS_BY_USERNAME_SQL = "SELECT username, password, enabled, user_id, display_name, TRUE AS is_token, token_type, jpolicy FROM solaruser.user_auth_token_login WHERE username = ?";
    public static final String DEFAULT_TOKEN_AUTHORITIES_BY_USERNAME_SQL = "SELECT username, authority FROM solaruser.user_auth_token_role WHERE username = ?";
    private List<GrantedAuthority> staticAuthorities;
    private final ObjectMapper objectMapper;
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    public JdbcUserDetailsService() {
        this(new ObjectMapper());
    }

    public JdbcUserDetailsService(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
        this.setUsersByUsernameQuery(DEFAULT_USERS_BY_USERNAME_SQL);
        this.setAuthoritiesByUsernameQuery(DEFAULT_AUTHORITIES_BY_USERNAME_SQL);
    }

    protected UserDetails createUserDetails(String username, UserDetails userFromUserQuery, List<GrantedAuthority> combinedAuthorities) {
        User user = (User)super.createUserDetails(username, userFromUserQuery, combinedAuthorities);
        if (userFromUserQuery instanceof AuthenticatedToken) {
            AuthenticatedToken token = (AuthenticatedToken)userFromUserQuery;
            return new AuthenticatedToken((UserDetails)user, token.getTokenType(), token.getUserId(), token.getPolicy());
        }
        AuthenticatedUser authUser = (AuthenticatedUser)userFromUserQuery;
        return new AuthenticatedUser(user, authUser.getUserId(), authUser.getName(), authUser.isAuthenticatedWithToken());
    }

    @Transactional(readOnly=true, propagation=Propagation.REQUIRED)
    protected List<UserDetails> loadUsersByUsername(String username) {
        return this.getJdbcTemplate().query(this.getUsersByUsernameQuery(), (RowMapper)new RowMapper<UserDetails>(){

            public UserDetails mapRow(ResultSet rs, int rowNum) throws SQLException {
                String username = rs.getString(1);
                String password = rs.getString(2);
                boolean enabled = rs.getBoolean(3);
                Long id = rs.getLong(4);
                String name = rs.getString(5);
                boolean authWithToken = rs.getBoolean(6);
                if (authWithToken) {
                    String tokenTypeString = rs.getString(7);
                    SecurityTokenType tokenType = null;
                    if (tokenTypeString != null) {
                        try {
                            tokenType = SecurityTokenType.valueOf(tokenTypeString);
                        }
                        catch (IllegalArgumentException e) {
                            JdbcUserDetailsService.this.log.warn("Unknown token type will be ignored: {}", (Object)tokenTypeString);
                        }
                    }
                    String policyJson = rs.getString(8);
                    SecurityPolicy policy = null;
                    if (policyJson != null && !"{}".equals(policyJson)) {
                        try {
                            policy = (SecurityPolicy)JdbcUserDetailsService.this.objectMapper.readValue(policyJson, BasicSecurityPolicy.class);
                        }
                        catch (IOException e) {
                            JdbcUserDetailsService.this.log.warn("Error deserializing SecurityPolicy from [{}]: {}", (Object)policyJson, (Object)e.getMessage());
                        }
                    }
                    return new AuthenticatedToken((UserDetails)new User(username, password, enabled, true, true, true, (Collection)AuthorityUtils.NO_AUTHORITIES), tokenType, id, policy);
                }
                return new AuthenticatedUser(new User(username, password, enabled, true, true, true, (Collection)AuthorityUtils.NO_AUTHORITIES), id, name, false);
            }
        }, new Object[]{username});
    }

    protected void addCustomAuthorities(String username, List<GrantedAuthority> authorities) {
        if (this.staticAuthorities != null) {
            authorities.addAll(this.staticAuthorities);
        }
    }

    public void setStaticRoles(List<String> roles) {
        ArrayList<GrantedAuthority> auths = new ArrayList<GrantedAuthority>(roles == null ? 0 : roles.size());
        for (String role : roles) {
            auths.add((GrantedAuthority)new SimpleGrantedAuthority(role));
        }
        this.staticAuthorities = auths;
    }
}

