/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.central.security.config;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.regex.Pattern;
import net.solarnetwork.web.jakarta.security.SecurityHttpServletRequestWrapper;
import org.springframework.util.unit.DataSize;

public class SecurityTokenFilterSettings {
    public static final long DEFALUT_MAX_DATE_SKEW = 900000L;
    public static final DataSize DEFAULT_MAX_REQUEST_BODY_SIZE = DataSize.ofBytes((long)65535L);
    public static final DataSize DEFAULT_MINIMUM_COMPRESS_LENGTH = DataSize.ofBytes((long)4096L);
    public static final DataSize DEFAULT_MINIMUM_SPOOL_LENGTH = DataSize.ofBytes((long)65536L);
    public static final Path DEFAULT_SPOOL_DIRECTORY = Paths.get(System.getProperty("java.io.tmpdir"), "SecurityTokenFilter");
    private long maxDateSkew = 900000L;
    private DataSize maxRequestBodySize = DEFAULT_MAX_REQUEST_BODY_SIZE;
    private DataSize minimumCompressLength = DEFAULT_MINIMUM_COMPRESS_LENGTH;
    private Pattern compressibleContentTypePattern = SecurityHttpServletRequestWrapper.DEFAULT_COMPRESSIBLE_CONTENT_PATTERN;
    private DataSize minimumSpoolLength = DEFAULT_MINIMUM_SPOOL_LENGTH;
    private Path spoolDirectory = DEFAULT_SPOOL_DIRECTORY;

    public long getMaxDateSkew() {
        return this.maxDateSkew;
    }

    public void setMaxDateSkew(long maxDateSkew) {
        this.maxDateSkew = maxDateSkew;
    }

    public DataSize getMaxRequestBodySize() {
        return this.maxRequestBodySize;
    }

    public void setMaxRequestBodySize(DataSize maxRequestBodySize) {
        if (maxRequestBodySize == null) {
            maxRequestBodySize = DEFAULT_MAX_REQUEST_BODY_SIZE;
        }
        this.maxRequestBodySize = maxRequestBodySize;
    }

    public DataSize getMinimumCompressLength() {
        return this.minimumCompressLength;
    }

    public void setMinimumCompressLength(DataSize minimumCompressLength) {
        this.minimumCompressLength = minimumCompressLength;
    }

    public Pattern getCompressibleContentTypePattern() {
        return this.compressibleContentTypePattern;
    }

    public void setCompressibleContentTypePattern(Pattern compressibleContentTypePattern) {
        this.compressibleContentTypePattern = compressibleContentTypePattern;
    }

    public DataSize getMinimumSpoolLength() {
        return this.minimumSpoolLength;
    }

    public void setMinimumSpoolLength(DataSize minimumSpoolLength) {
        this.minimumSpoolLength = minimumSpoolLength;
    }

    public Path getSpoolDirectory() {
        return this.spoolDirectory;
    }

    public void setSpoolDirectory(Path spoolDirectory) {
        this.spoolDirectory = spoolDirectory;
    }
}

