/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.central.security.config;

import java.security.SecureRandom;
import java.util.LinkedHashMap;
import net.solarnetwork.central.security.DelegatingPasswordEncoder;
import net.solarnetwork.central.security.LegacyPasswordEncoder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.security.crypto.password.PasswordEncoder;

@Configuration(proxyBeanMethods=false)
public class PasswordEncoderConfig {
    @Bean
    public DelegatingPasswordEncoder passwordEncoder() {
        LinkedHashMap<String, PasswordEncoder> encoders = new LinkedHashMap<String, PasswordEncoder>(2);
        encoders.put("$2a$", (PasswordEncoder)new BCryptPasswordEncoder(BCryptPasswordEncoder.BCryptVersion.$2A, 12, new SecureRandom()));
        encoders.put("{SHA}", new LegacyPasswordEncoder());
        return new DelegatingPasswordEncoder(encoders);
    }
}

