/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.central.security;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.solarnetwork.central.dao.SolarNodeOwnershipDao;
import net.solarnetwork.central.domain.SolarNodeOwnership;
import net.solarnetwork.central.domain.UserIdRelated;
import net.solarnetwork.central.security.AuthenticatedNode;
import net.solarnetwork.central.security.AuthenticatedToken;
import net.solarnetwork.central.security.AuthenticatedUser;
import net.solarnetwork.central.security.AuthorizationException;
import net.solarnetwork.central.security.NodeUserDetailsService;
import net.solarnetwork.central.security.SecurityActor;
import net.solarnetwork.central.security.SecurityException;
import net.solarnetwork.central.security.SecurityNode;
import net.solarnetwork.central.security.SecurityPolicy;
import net.solarnetwork.central.security.SecurityToken;
import net.solarnetwork.central.security.SecurityTokenType;
import net.solarnetwork.central.security.SecurityUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.web.authentication.preauth.PreAuthenticatedAuthenticationToken;

public class SecurityUtils {
    private static final Logger LOG = LoggerFactory.getLogger(SecurityUtils.class);

    public static void authenticate(AuthenticationManager authenticationManager, Object username, Object password) {
        try {
            UsernamePasswordAuthenticationToken usernameAndPassword = new UsernamePasswordAuthenticationToken(username, password);
            Authentication auth = authenticationManager.authenticate((Authentication)usernameAndPassword);
            SecurityContextHolder.getContext().setAuthentication(auth);
        }
        catch (AuthenticationException e) {
            SecurityContextHolder.getContext().setAuthentication(null);
            throw e;
        }
    }

    public static void removeAuthentication() {
        SecurityContextHolder.getContext().setAuthentication(null);
    }

    public static SecurityToken becomeToken(String tokenId, SecurityTokenType type, Long userId, SecurityPolicy policy) {
        AuthenticatedToken token = new AuthenticatedToken((UserDetails)new User(tokenId, "", true, true, true, true, (Collection)AuthorityUtils.NO_AUTHORITIES), type, userId, policy);
        Set<SimpleGrantedAuthority> authorities = Collections.singleton(new SimpleGrantedAuthority("RUN_AS_ROLE_USER"));
        PreAuthenticatedAuthenticationToken auth = new PreAuthenticatedAuthenticationToken((Object)token, (Object)"", authorities);
        SecurityContextHolder.getContext().setAuthentication((Authentication)auth);
        return token;
    }

    public static SecurityUser becomeUser(String username, String name, Long userId) {
        User userDetails = new User(username, "", (Collection)AuthorityUtils.NO_AUTHORITIES);
        AuthenticatedUser user = new AuthenticatedUser(userDetails, userId, name, false);
        Set<SimpleGrantedAuthority> authorities = Collections.singleton(new SimpleGrantedAuthority("RUN_AS_ROLE_USER"));
        UsernamePasswordAuthenticationToken auth = new UsernamePasswordAuthenticationToken((Object)user, (Object)"", authorities);
        SecurityContextHolder.getContext().setAuthentication((Authentication)auth);
        return user;
    }

    public static SecurityNode becomeNode(Long nodeId) {
        AuthenticatedNode node = new AuthenticatedNode(nodeId, NodeUserDetailsService.AUTHORITIES, false);
        Set<SimpleGrantedAuthority> authorities = Collections.singleton(new SimpleGrantedAuthority("RUN_AS_ROLE_NODE"));
        UsernamePasswordAuthenticationToken auth = new UsernamePasswordAuthenticationToken((Object)node, (Object)"", authorities);
        SecurityContextHolder.getContext().setAuthentication((Authentication)auth);
        return node;
    }

    public static void requireAnyRole(Set<String> roles) {
        Authentication auth = SecurityUtils.getCurrentAuthentication();
        if (auth == null || !auth.isAuthenticated()) {
            throw new AuthorizationException(AuthorizationException.Reason.ANONYMOUS_ACCESS_DENIED, null);
        }
        for (GrantedAuthority role : auth.getAuthorities()) {
            if (!roles.contains(role.getAuthority().toUpperCase())) continue;
            return;
        }
        throw new AuthorizationException(AuthorizationException.Reason.ACCESS_DENIED, null);
    }

    public static void requireAllRoles(Set<String> roles) {
        Authentication auth = SecurityUtils.getCurrentAuthentication();
        if (auth == null || !auth.isAuthenticated()) {
            throw new AuthorizationException(AuthorizationException.Reason.ANONYMOUS_ACCESS_DENIED, null);
        }
        HashSet<String> rolesCopy = new HashSet<String>(roles);
        for (GrantedAuthority role : auth.getAuthorities()) {
            if (!rolesCopy.remove(role.getAuthority().toUpperCase())) {
                throw new AuthorizationException(AuthorizationException.Reason.ACCESS_DENIED, null);
            }
            if (rolesCopy.size() >= 1) continue;
            return;
        }
        if (rolesCopy.size() > 0) {
            throw new AuthorizationException(AuthorizationException.Reason.ACCESS_DENIED, null);
        }
    }

    public static Authentication getCurrentAuthentication() {
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        if (auth == null) {
            LOG.debug("No Authentication available, cannot tell current user");
            return null;
        }
        return auth;
    }

    public static SecurityActor getCurrentActor() throws SecurityException {
        return SecurityUtils.getActor(SecurityUtils.getCurrentAuthentication());
    }

    public static SecurityActor getActor(Authentication auth) {
        Object object;
        if (auth instanceof SecurityActor) {
            SecurityActor a = (SecurityActor)auth;
            return a;
        }
        if (auth != null && (object = auth.getPrincipal()) instanceof SecurityActor) {
            SecurityActor a = (SecurityActor)object;
            return a;
        }
        if (auth != null && (object = auth.getDetails()) instanceof SecurityActor) {
            SecurityActor a = (SecurityActor)object;
            return a;
        }
        throw new SecurityException("Actor not available");
    }

    public static Long getCurrentActorUserId() throws SecurityException {
        return SecurityUtils.getActorUserId(SecurityUtils.getCurrentAuthentication());
    }

    public static Long getActorUserId(Authentication auth) throws SecurityException {
        Long userId = null;
        if (auth instanceof UserIdRelated) {
            UserIdRelated u = (UserIdRelated)auth;
            userId = u.getUserId();
        } else {
            Object object = auth.getDetails();
            if (object instanceof UserIdRelated) {
                UserIdRelated u = (UserIdRelated)object;
                userId = u.getUserId();
            } else {
                SecurityActor actor = SecurityUtils.getActor(auth);
                if (actor instanceof UserIdRelated) {
                    UserIdRelated u = (UserIdRelated)((Object)actor);
                    userId = u.getUserId();
                }
            }
        }
        if (userId != null) {
            return userId;
        }
        throw new SecurityException("User not available");
    }

    public static SecurityToken getCurrentToken() throws SecurityException {
        return SecurityUtils.getToken(SecurityUtils.getCurrentAuthentication());
    }

    public static SecurityToken getToken(Authentication auth) throws SecurityException {
        if (auth != null && auth.getPrincipal() instanceof SecurityToken) {
            return (SecurityToken)auth.getPrincipal();
        }
        if (auth != null && auth.getDetails() instanceof SecurityToken) {
            return (SecurityToken)auth.getDetails();
        }
        throw new SecurityException("Token not available");
    }

    public static String currentTokenId() {
        try {
            return SecurityUtils.getCurrentToken().getToken();
        }
        catch (SecurityException e) {
            return null;
        }
    }

    public static SecurityUser getCurrentUser() throws SecurityException {
        return SecurityUtils.getUser(SecurityUtils.getCurrentAuthentication());
    }

    public static SecurityUser getUser(Authentication auth) throws SecurityException {
        if (auth != null && auth.getPrincipal() instanceof SecurityUser) {
            return (SecurityUser)auth.getPrincipal();
        }
        if (auth != null && auth.getDetails() instanceof SecurityUser) {
            return (SecurityUser)auth.getDetails();
        }
        throw new SecurityException("User not available");
    }

    public static SecurityNode getCurrentNode() throws SecurityException {
        return SecurityUtils.getNode(SecurityUtils.getCurrentAuthentication());
    }

    public static SecurityNode getNode(Authentication auth) throws SecurityException {
        if (auth != null && auth.getPrincipal() instanceof SecurityNode) {
            return (SecurityNode)auth.getPrincipal();
        }
        if (auth != null && auth.getDetails() instanceof SecurityNode) {
            return (SecurityNode)auth.getDetails();
        }
        throw new SecurityException("Node not available");
    }

    public static Long[] authorizedNodeIdsForCurrentActor(SolarNodeOwnershipDao nodeOwnershipDao) {
        return SecurityUtils.authorizedNodeIds(SecurityUtils.getCurrentAuthentication(), nodeOwnershipDao);
    }

    public static Long[] authorizedNodeIds(Authentication auth, SolarNodeOwnershipDao nodeOwnershipDao) {
        SecurityActor actor;
        try {
            actor = SecurityUtils.getActor(auth);
        }
        catch (SecurityException e2) {
            LOG.warn("Access DENIED to node {} for non-authenticated user");
            throw new AuthorizationException(AuthorizationException.Reason.ACCESS_DENIED, null);
        }
        if (actor instanceof SecurityNode) {
            SecurityNode node = (SecurityNode)actor;
            return new Long[]{node.getNodeId()};
        }
        if (actor instanceof SecurityUser) {
            SecurityUser user = (SecurityUser)actor;
            SolarNodeOwnership[] ownerships = nodeOwnershipDao.ownershipsForUserId(user.getUserId());
            if (ownerships != null && ownerships.length > 0) {
                return (Long[])Arrays.stream(ownerships).map(SolarNodeOwnership::getNodeId).toArray(Long[]::new);
            }
        } else if (actor instanceof SecurityToken) {
            SecurityToken token = (SecurityToken)actor;
            Long[] result = null;
            SolarNodeOwnership[] ownerships = nodeOwnershipDao.ownershipsForUserId(token.getUserId());
            Long[] allNodeIds = ownerships != null ? (Long[])Arrays.stream(ownerships).map(SolarNodeOwnership::getNodeId).toArray(Long[]::new) : null;
            Set<Long> restrictedToNodeIds = SecurityUtils.tokenRestrictedNodeIds(token);
            result = restrictedToNodeIds != null ? (Long[])Arrays.stream(allNodeIds).filter(e -> restrictedToNodeIds.contains(e)).toArray(Long[]::new) : allNodeIds;
            if (result != null && result.length > 0) {
                return result;
            }
        }
        throw new AuthorizationException(AuthorizationException.Reason.ACCESS_DENIED, null);
    }

    private static Set<Long> tokenRestrictedNodeIds(SecurityToken token) {
        Set restrictedToNodeIds = null;
        if (SecurityTokenType.User == token.getTokenType()) {
            restrictedToNodeIds = token.getPolicy() != null && token.getPolicy().getNodeIds() != null ? token.getPolicy().getNodeIds() : null;
        } else if (SecurityTokenType.ReadNodeData == token.getTokenType()) {
            restrictedToNodeIds = token.getPolicy() != null && token.getPolicy().getNodeIds() != null ? token.getPolicy().getNodeIds() : Collections.emptySet();
        }
        return restrictedToNodeIds;
    }

    public static SecurityPolicy getActiveSecurityPolicy() {
        SecurityActor actor;
        try {
            actor = SecurityUtils.getCurrentActor();
        }
        catch (SecurityException e) {
            return null;
        }
        if (actor instanceof SecurityToken) {
            SecurityToken token = (SecurityToken)actor;
            return token.getPolicy();
        }
        return null;
    }
}

