/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.central.security;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.time.Instant;
import java.util.Arrays;
import java.util.Set;
import net.solarnetwork.central.domain.LocationPrecision;
import net.solarnetwork.central.security.SecurityPolicy;
import net.solarnetwork.domain.datum.Aggregation;

public class SecurityPolicySerializer
extends StdSerializer<SecurityPolicy> {
    private static final long serialVersionUID = -5542903806671694581L;

    public SecurityPolicySerializer() {
        super(SecurityPolicy.class);
    }

    public void serialize(SecurityPolicy policy, JsonGenerator generator, SerializerProvider provider) throws IOException, JsonGenerationException {
        Boolean refreshAllowed;
        Instant instant;
        Set<String> set;
        Set<String> userMetadataPaths;
        if (policy == null) {
            generator.writeNull();
            return;
        }
        generator.writeStartObject();
        if (policy.getNodeIds() != null && !policy.getNodeIds().isEmpty()) {
            generator.writeArrayFieldStart("nodeIds");
            Object[] ids = policy.getNodeIds().toArray(new Long[policy.getNodeIds().size()]);
            Arrays.sort(ids);
            for (Object object : ids) {
                generator.writeNumber(((Long)object).longValue());
            }
            generator.writeEndArray();
        }
        if (policy.getSourceIds() != null && !policy.getSourceIds().isEmpty()) {
            generator.writeArrayFieldStart("sourceIds");
            for (String string : policy.getSourceIds()) {
                generator.writeString(string);
            }
            generator.writeEndArray();
        }
        Set<Aggregation> aggregations = policy.getAggregations();
        if (policy.getMinAggregation() != null) {
            generator.writeStringField("minAggregation", policy.getMinAggregation().name());
        } else if (aggregations != null && !aggregations.isEmpty()) {
            generator.writeArrayFieldStart("aggregations");
            for (Aggregation val : aggregations) {
                generator.writeString(val.name());
            }
            generator.writeEndArray();
        }
        Set<LocationPrecision> set2 = policy.getLocationPrecisions();
        if (policy.getMinLocationPrecision() != null) {
            generator.writeStringField("minLocationPrecision", policy.getMinLocationPrecision().name());
        } else if (set2 != null && !set2.isEmpty()) {
            generator.writeArrayFieldStart("locationPrecisions");
            for (LocationPrecision val : set2) {
                generator.writeString(val.name());
            }
            generator.writeEndArray();
        }
        Set<String> nodeMetadataPaths = policy.getNodeMetadataPaths();
        if (nodeMetadataPaths != null && !nodeMetadataPaths.isEmpty()) {
            generator.writeArrayFieldStart("nodeMetadataPaths");
            for (String string : nodeMetadataPaths) {
                generator.writeString(string);
            }
            generator.writeEndArray();
        }
        if ((userMetadataPaths = policy.getUserMetadataPaths()) != null && !userMetadataPaths.isEmpty()) {
            generator.writeArrayFieldStart("userMetadataPaths");
            for (String string : userMetadataPaths) {
                generator.writeString(string);
            }
            generator.writeEndArray();
        }
        if ((set = policy.getApiPaths()) != null && !set.isEmpty()) {
            generator.writeArrayFieldStart("apiPaths");
            for (String path : set) {
                generator.writeString(path);
            }
            generator.writeEndArray();
        }
        if ((instant = policy.getNotAfter()) != null) {
            generator.writeNumberField("notAfter", instant.toEpochMilli());
        }
        if ((refreshAllowed = policy.getRefreshAllowed()) != null) {
            generator.writeBooleanField("refreshAllowed", refreshAllowed.booleanValue());
        }
        generator.writeEndObject();
    }
}

