/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.central.security;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import net.solarnetwork.central.security.AuthorizationException;
import net.solarnetwork.central.security.SecurityPolicy;
import net.solarnetwork.central.security.SecurityPolicyMetadataType;
import net.solarnetwork.domain.datum.Aggregation;
import net.solarnetwork.domain.datum.GeneralDatumMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ClassUtils;
import org.springframework.util.PathMatcher;

public class SecurityPolicyEnforcer
implements InvocationHandler {
    private final Object delegate;
    private final SecurityPolicy policy;
    private final Object principal;
    private final PathMatcher pathMatcher;
    private final SecurityPolicyMetadataType metadataType;
    private Long[] cachedNodeIds;
    private String[] cachedSourceIds;
    private GeneralDatumMetadata cachedMetadata;
    private static final Logger LOG = LoggerFactory.getLogger(SecurityPolicyEnforcer.class);

    public SecurityPolicyEnforcer(SecurityPolicy policy, Object principal, Object delegate) {
        this(policy, principal, delegate, null);
    }

    public SecurityPolicyEnforcer(SecurityPolicy policy, Object principal, Object delegate, PathMatcher pathMatcher) {
        this(policy, principal, delegate, pathMatcher, null);
    }

    public SecurityPolicyEnforcer(SecurityPolicy policy, Object principal, Object delegate, PathMatcher pathMatcher, SecurityPolicyMetadataType metadataType) {
        this.delegate = delegate;
        this.policy = policy;
        this.principal = principal;
        this.pathMatcher = pathMatcher;
        this.metadataType = metadataType;
    }

    public static <T> T createSecurityPolicyProxy(SecurityPolicyEnforcer enforcer) {
        Class[] interfaces = ClassUtils.getAllInterfaces((Object)enforcer.getDelgate());
        return (T)Proxy.newProxyInstance(enforcer.getDelgate().getClass().getClassLoader(), interfaces, (InvocationHandler)enforcer);
    }

    public void verify() {
        String[] getters;
        for (String methodName : getters = new String[]{"getNodeIds", "getSourceIds", "getAggregation", "getMetadata"}) {
            try {
                Method m = this.delegate.getClass().getMethod(methodName, new Class[0]);
                this.invoke(null, m, null);
            }
            catch (AuthorizationException e) {
                throw e;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String methodName = method.getName();
        Object delegateResult = method.invoke(this.delegate, args);
        if ("getNodeIds".equals(methodName) || "getNodeId".equals(methodName)) {
            Long[] nodeIds;
            if (methodName.endsWith("s")) {
                nodeIds = (Long[])delegateResult;
            } else {
                Long[] longArray;
                if (delegateResult != null) {
                    Long[] longArray2 = new Long[1];
                    longArray = longArray2;
                    longArray2[0] = (Long)delegateResult;
                } else {
                    longArray = null;
                }
                nodeIds = longArray;
            }
            Long[] result = this.verifyNodeIds(nodeIds);
            if (result == null || result.length < 1 || methodName.endsWith("s")) {
                return result;
            }
            return result[0];
        }
        if ("getSourceIds".equals(methodName) || "getSourceId".equals(methodName)) {
            String[] sourceIds;
            if (methodName.endsWith("s")) {
                sourceIds = (String[])delegateResult;
            } else {
                String[] stringArray;
                if (delegateResult != null) {
                    String[] stringArray2 = new String[1];
                    stringArray = stringArray2;
                    stringArray2[0] = (String)delegateResult;
                } else {
                    stringArray = null;
                }
                sourceIds = stringArray;
            }
            String[] result = this.verifySourceIds(sourceIds, true);
            if (result == null || result.length < 1 || methodName.endsWith("s")) {
                return result;
            }
            return result[0];
        }
        if ("getAggregation".equals(methodName)) {
            Aggregation agg = (Aggregation)delegateResult;
            return this.verifyAggregation(agg);
        }
        if ("getMetadata".equals(methodName)) {
            GeneralDatumMetadata meta = (GeneralDatumMetadata)delegateResult;
            return this.verifyMetadata(meta, true);
        }
        return delegateResult;
    }

    public Long[] verifyNodeIds(Long[] nodeIds) {
        Set<Long> policyNodeIds = this.policy.getNodeIds();
        if (policyNodeIds == null || policyNodeIds.isEmpty()) {
            return nodeIds;
        }
        if (this.cachedNodeIds != null) {
            return this.cachedNodeIds.length == 0 ? null : this.cachedNodeIds;
        }
        if (nodeIds != null && nodeIds.length > 0) {
            LinkedHashSet<Long> nodeIdsSet = new LinkedHashSet<Long>(Arrays.asList(nodeIds));
            Iterator itr = nodeIdsSet.iterator();
            while (itr.hasNext()) {
                Long nodeId = (Long)itr.next();
                if (policyNodeIds.contains(nodeId)) continue;
                LOG.warn("Access DENIED to node {} for {}: policy restriction", (Object)nodeId, this.principal);
                itr.remove();
            }
            if (nodeIdsSet.size() < 1) {
                LOG.warn("Access DENIED to nodes {} for {}", (Object)nodeIds, this.principal);
                throw new AuthorizationException(AuthorizationException.Reason.ACCESS_DENIED, nodeIds);
            }
            if (nodeIdsSet.size() < nodeIds.length) {
                nodeIds = nodeIdsSet.toArray(new Long[nodeIdsSet.size()]);
            }
        } else if (nodeIds == null || nodeIds.length < 1) {
            LOG.info("Access RESTRICTED to nodes {} for {}", policyNodeIds, this.principal);
            nodeIds = policyNodeIds.toArray(new Long[policyNodeIds.size()]);
        }
        this.cachedNodeIds = nodeIds == null ? new Long[]{} : nodeIds;
        return nodeIds;
    }

    private boolean matchesPattern(Set<String> patterns, String value) {
        for (String pattern : patterns) {
            if (!this.pathMatcher.match(pattern, value)) continue;
            return true;
        }
        return false;
    }

    private boolean matchesPatternStart(Set<String> patterns, String value) {
        for (String pattern : patterns) {
            if (!this.pathMatcher.matchStart(pattern, value)) continue;
            return true;
        }
        return false;
    }

    public String[] verifySourceIds(String[] sourceIds) {
        return this.verifySourceIds(sourceIds, false);
    }

    private String[] verifySourceIds(String[] sourceIds, boolean cacheResults) {
        Set<String> policySourceIds = this.policy.getSourceIds();
        if (policySourceIds == null || policySourceIds.isEmpty()) {
            return sourceIds;
        }
        if (cacheResults && this.cachedSourceIds != null) {
            return this.cachedSourceIds.length == 0 ? null : this.cachedSourceIds;
        }
        if (sourceIds != null && sourceIds.length > 0) {
            LinkedHashSet<String> sourceIdsSet = new LinkedHashSet<String>(Arrays.asList(sourceIds));
            LinkedHashSet<String> policySourceIdPatterns = null;
            LinkedHashSet<Object> sourceIdPatterns = null;
            if (this.pathMatcher != null) {
                for (String string : policySourceIds) {
                    if (!this.pathMatcher.isPattern(string)) continue;
                    if (policySourceIdPatterns == null) {
                        policySourceIdPatterns = new LinkedHashSet<String>(policySourceIds.size());
                    }
                    policySourceIdPatterns.add(string);
                }
                if (policySourceIdPatterns != null) {
                    LinkedHashSet<String> mutablePolicySourceIds = new LinkedHashSet<String>(policySourceIds);
                    mutablePolicySourceIds.removeAll(policySourceIdPatterns);
                    policySourceIds = mutablePolicySourceIds;
                }
                for (String sourceId : sourceIds) {
                    if (!this.pathMatcher.isPattern(sourceId)) continue;
                    if (sourceIdPatterns == null) {
                        sourceIdPatterns = new LinkedHashSet<Object>(sourceIds.length);
                    }
                    sourceIdPatterns.add(sourceId);
                    sourceIdsSet.remove(sourceId);
                }
            }
            Iterator itr = sourceIdsSet.iterator();
            while (itr.hasNext()) {
                String string = (String)itr.next();
                if (policySourceIds.contains(string) || policySourceIdPatterns != null && this.matchesPattern((Set<String>)policySourceIdPatterns, string)) continue;
                LOG.warn("Access DENIED to source {} for {}: policy restriction", (Object)string, this.principal);
                itr.remove();
            }
            if (sourceIdPatterns != null) {
                if (policySourceIdPatterns != null) {
                    for (String string : sourceIdPatterns) {
                        if (policySourceIdPatterns.contains(string)) {
                            sourceIdsSet.add(string);
                            continue;
                        }
                        LOG.warn("Access DENIED to source {} for {}: policy restriction", (Object)string, this.principal);
                    }
                }
                for (String string : policySourceIds) {
                    if (!this.matchesPattern((Set<String>)sourceIdPatterns, string)) continue;
                    sourceIdsSet.add(string);
                }
            }
            if (sourceIdsSet.isEmpty()) {
                LOG.warn("Access DENIED to sources {} for {}", (Object)sourceIds, this.principal);
                throw new AuthorizationException(AuthorizationException.Reason.ACCESS_DENIED, sourceIds);
            }
            if (!sourceIdsSet.equals(new HashSet<String>(Arrays.asList(sourceIds)))) {
                sourceIds = sourceIdsSet.toArray(new String[sourceIdsSet.size()]);
            }
        } else if (sourceIds == null || sourceIds.length < 1) {
            LOG.info("Access RESTRICTED to sources {} for {}", policySourceIds, this.principal);
            sourceIds = policySourceIds.toArray(new String[policySourceIds.size()]);
        }
        if (cacheResults) {
            this.cachedSourceIds = sourceIds == null ? new String[]{} : sourceIds;
        }
        return sourceIds;
    }

    private Aggregation verifyAggregation(Aggregation agg) {
        Aggregation min = this.policy.getMinAggregation();
        if (min != null) {
            if (agg == null || agg.compareLevel(min) < 0) {
                LOG.info("Access RESTRICTED from aggregation {} to {} for {}", new Object[]{agg, min, this.principal});
                return min;
            }
            return agg;
        }
        Set<Aggregation> allowed = this.policy.getAggregations();
        if (allowed == null || allowed.isEmpty() || allowed.contains(agg)) {
            return agg;
        }
        LOG.warn("Access DENIED to aggregation {} for {}", (Object)agg, this.principal);
        throw new AuthorizationException(AuthorizationException.Reason.ACCESS_DENIED, agg);
    }

    public GeneralDatumMetadata verifyMetadata(GeneralDatumMetadata metadata) {
        return this.verifyMetadata(metadata, false);
    }

    private GeneralDatumMetadata verifyMetadata(GeneralDatumMetadata meta, boolean cacheResults) {
        Map<String, Object> pm;
        Set<Object> policyMetadataPaths = switch (this.metadataType) {
            case SecurityPolicyMetadataType.Node -> this.policy.getNodeMetadataPaths();
            case SecurityPolicyMetadataType.User -> this.policy.getUserMetadataPaths();
            default -> Collections.emptySet();
        };
        if (meta == null || policyMetadataPaths == null || policyMetadataPaths.isEmpty()) {
            return meta;
        }
        if (cacheResults && this.cachedMetadata != null) {
            return this.cachedMetadata;
        }
        Map<String, Object> infoMap = null;
        if (meta.getInfo() != null) {
            infoMap = this.enforceMetadataPaths(policyMetadataPaths, meta.getInfo(), "/m");
        }
        Map<String, Object> propMap = null;
        if (meta.getPropertyInfo() != null) {
            pm = meta.getPropertyInfo();
            propMap = this.enforceMetadataPaths(policyMetadataPaths, pm, "/pm");
        }
        pm = propMap;
        GeneralDatumMetadata result = new GeneralDatumMetadata(infoMap, (Map)pm);
        result.setTags(meta.getTags());
        if (result.equals((Object)meta)) {
            return meta;
        }
        if (infoMap == null && propMap == null) {
            LOG.warn("Access DENIED to metadata {} on {} for {}", new Object[]{meta, this.delegate, this.principal});
            throw new AuthorizationException(AuthorizationException.Reason.ACCESS_DENIED, meta);
        }
        if (cacheResults) {
            this.cachedMetadata = result;
        }
        return result;
    }

    private Map<String, Object> enforceMetadataPaths(Set<String> policyPaths, Map<String, Object> meta, String path) {
        if (meta == null) {
            return null;
        }
        LinkedHashMap<String, Object> result = null;
        for (Map.Entry<String, Object> me : meta.entrySet()) {
            String entryPath = path + "/" + me.getKey();
            Object val = me.getValue();
            if (val instanceof Map) {
                if (!this.matchesPatternStart(policyPaths, entryPath)) continue;
                Map<String, Object> mapVal = (Map<String, Object>)val;
                if ((mapVal = this.enforceMetadataPaths(policyPaths, mapVal, entryPath)) == null) continue;
                if (result == null) {
                    result = new LinkedHashMap(meta.size());
                }
                result.put(me.getKey(), mapVal);
                continue;
            }
            if (!this.matchesPattern(policyPaths, entryPath)) continue;
            if (result == null) {
                result = new LinkedHashMap<String, Object>(meta.size());
            }
            result.put(me.getKey(), val);
        }
        if (result == null || result.isEmpty()) {
            return null;
        }
        return result;
    }

    public Object getDelgate() {
        return this.delegate;
    }
}

