/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.central.security;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import net.solarnetwork.central.security.AuthenticatedNode;
import org.springframework.dao.DataAccessException;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;

public class NodeUserDetailsService
implements UserDetailsService {
    protected static final Collection<GrantedAuthority> AUTHORITIES = NodeUserDetailsService.getAuthorities();

    private static Collection<GrantedAuthority> getAuthorities() {
        ArrayList<SimpleGrantedAuthority> authorities = new ArrayList<SimpleGrantedAuthority>(1);
        authorities.add(new SimpleGrantedAuthority("ROLE_NODE"));
        return Collections.unmodifiableCollection(authorities);
    }

    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException, DataAccessException {
        try {
            Long id = Long.valueOf(username);
            return new AuthenticatedNode(id, AUTHORITIES, false);
        }
        catch (NumberFormatException e) {
            throw new UsernameNotFoundException("Username [" + username + "] is not a valid ndoe ID.");
        }
    }
}

