/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.central.security;

import java.util.Map;
import net.solarnetwork.util.ObjectUtils;
import org.springframework.security.crypto.password.PasswordEncoder;

public class DelegatingPasswordEncoder
implements net.solarnetwork.service.PasswordEncoder,
PasswordEncoder {
    private final Map<String, PasswordEncoder> encoders;

    public DelegatingPasswordEncoder(Map<String, PasswordEncoder> encoders) {
        this.encoders = (Map)ObjectUtils.requireNonNullArgument(encoders, (String)"encoders");
    }

    public boolean isPasswordEncrypted(CharSequence password) {
        if (this.encoders == null || password == null) {
            return false;
        }
        for (String prefix : this.encoders.keySet()) {
            if (password.length() <= prefix.length() || !password.subSequence(0, prefix.length()).equals(prefix)) continue;
            return true;
        }
        return false;
    }

    public String encode(CharSequence rawPassword) {
        if (this.encoders == null || this.encoders.size() < 1) {
            throw new RuntimeException("No password encoders configured");
        }
        Map.Entry<String, PasswordEncoder> entry = this.encoders.entrySet().iterator().next();
        return entry.getValue().encode(rawPassword);
    }

    public boolean matches(CharSequence rawPassword, String encodedPassword) {
        if (encodedPassword == null || rawPassword == null) {
            return false;
        }
        for (Map.Entry<String, PasswordEncoder> entry : this.encoders.entrySet()) {
            String prefixTag = entry.getKey();
            if (!encodedPassword.startsWith(prefixTag)) continue;
            return entry.getValue().matches(rawPassword, encodedPassword);
        }
        return false;
    }
}

