/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.central.security;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.CertPath;
import java.security.cert.CertPathValidator;
import java.security.cert.CertPathValidatorResult;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateParsingException;
import java.security.cert.PKIXCertPathValidatorResult;
import java.security.cert.PKIXParameters;
import java.security.cert.X509Certificate;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.solarnetwork.service.CertificateException;
import net.solarnetwork.util.ObjectUtils;
import org.bouncycastle.util.io.pem.PemObject;
import org.bouncycastle.util.io.pem.PemReader;

public final class CertificateUtils {
    public static final Integer RFC_822_SAN_ID = 1;
    public static final String EMAIL_ADDRESS_OID = "1.2.840.113549.1.9.1";
    public static final String X509_CERTIFICATE_TYPE = "X.509";
    private static final Map<String, String> CANONICAL_DN_MAPPING;
    private static final CertificateFactory X509_CERT_FACTORY;

    private static CertificateFactory defaultX509CertificateFactory() {
        try {
            return CertificateFactory.getInstance(X509_CERTIFICATE_TYPE);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static CertificateFactory x509CertificateFactory() {
        if (X509_CERT_FACTORY != null) {
            return X509_CERT_FACTORY;
        }
        try {
            return CertificateFactory.getInstance(X509_CERTIFICATE_TYPE);
        }
        catch (Exception e) {
            throw new CertificateException("Error obtaining X.509 certificate factory.", (Throwable)e);
        }
    }

    public static String emailSubjectAlternativeName(X509Certificate cert) throws CertificateParsingException {
        Collection<List<?>> alts = ((X509Certificate)ObjectUtils.requireNonNullArgument((Object)cert, (String)"cert")).getSubjectAlternativeNames();
        if (alts == null) {
            return null;
        }
        for (List<?> entry : alts) {
            Object val;
            if (entry.size() <= 1 || !RFC_822_SAN_ID.equals(entry.get(0)) || (val = entry.get(1)) == null) continue;
            return val.toString();
        }
        return null;
    }

    public static String canonicalSubjectDn(X509Certificate cert) {
        return ((X509Certificate)ObjectUtils.requireNonNullArgument((Object)cert, (String)"cert")).getSubjectX500Principal().getName("RFC2253", CANONICAL_DN_MAPPING);
    }

    public static X509Certificate[] parsePemCertificates(Reader pemData) throws CertificateException {
        ArrayList<X509Certificate> results = new ArrayList<X509Certificate>(3);
        try (PemReader reader = new PemReader(pemData);){
            PemObject pemObj;
            CertificateFactory cf = CertificateFactory.getInstance(X509_CERTIFICATE_TYPE);
            while ((pemObj = reader.readPemObject()) != null) {
                Collection<? extends Certificate> certs = cf.generateCertificates(new ByteArrayInputStream(pemObj.getContent()));
                for (Certificate certificate : certs) {
                    if (!(certificate instanceof X509Certificate)) continue;
                    X509Certificate x509 = (X509Certificate)certificate;
                    results.add(x509);
                }
            }
        }
        catch (IOException e) {
            throw new CertificateException("Error reading certificate", (Throwable)e);
        }
        catch (java.security.cert.CertificateException e) {
            throw new CertificateException("Error loading CertificateFactory", (Throwable)e);
        }
        return (X509Certificate[])results.toArray(X509Certificate[]::new);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static KeyStore serverKeyStore(Path certificatePath, Path certificateKey, String alias) throws CertificateException {
        Certificate[] certs;
        if (certificatePath == null || certificateKey == null || alias == null) {
            return null;
        }
        try {
            certs = CertificateUtils.parsePemCertificates(Files.newBufferedReader(certificatePath, StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            throw new CertificateException("Error reading server certificate path [%s]: %s".formatted(certificatePath, e.toString()));
        }
        try (BufferedReader reader = Files.newBufferedReader(certificateKey);){
            KeyStore keyStore;
            try (PemReader pemReader = new PemReader((Reader)reader);){
                KeyStore result = KeyStore.getInstance(KeyStore.getDefaultType());
                result.load(null);
                KeyFactory factory = KeyFactory.getInstance("RSA");
                PrivateKey privateKey = null;
                PemObject pemObject = pemReader.readPemObject();
                byte[] content = pemObject.getContent();
                PKCS8EncodedKeySpec privKeySpec = new PKCS8EncodedKeySpec(content);
                privateKey = factory.generatePrivate(privKeySpec);
                result.setKeyEntry(alias, privateKey, new char[0], certs);
                keyStore = result;
            }
            return keyStore;
        }
        catch (Exception e) {
            throw new CertificateException("Error initializing certificate key store.", (Throwable)e);
        }
    }

    public static PKIXCertPathValidatorResult validateCertificateChain(KeyStore trustStore, X509Certificate[] chain) throws CertificateException {
        try {
            CertificateFactory cf = CertificateFactory.getInstance(X509_CERTIFICATE_TYPE);
            CertPath path = cf.generateCertPath(Arrays.asList(chain));
            PKIXParameters pkixParams = new PKIXParameters(trustStore);
            pkixParams.setRevocationEnabled(false);
            CertPathValidator validator = CertPathValidator.getInstance("PKIX");
            CertPathValidatorResult result = validator.validate(path, pkixParams);
            return (PKIXCertPathValidatorResult)result;
        }
        catch (Exception e) {
            throw new CertificateException((Throwable)e);
        }
    }

    static {
        HashMap<String, String> m = new HashMap<String, String>(4);
        m.put(EMAIL_ADDRESS_OID, "emailAddress");
        CANONICAL_DN_MAPPING = Collections.unmodifiableMap(m);
        X509_CERT_FACTORY = CertificateUtils.defaultX509CertificateFactory();
    }
}

