/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.central.security;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.Serializable;
import java.time.Instant;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import net.solarnetwork.central.domain.LocationPrecision;
import net.solarnetwork.central.security.SecurityPolicy;
import net.solarnetwork.central.security.SecurityPolicySerializer;
import net.solarnetwork.domain.datum.Aggregation;

@JsonDeserialize(builder=Builder.class)
@JsonSerialize(using=SecurityPolicySerializer.class)
public class BasicSecurityPolicy
implements SecurityPolicy,
Serializable {
    private static final long serialVersionUID = 2178988304971356373L;
    private final Set<Long> nodeIds;
    private final Set<String> sourceIds;
    private final Set<Aggregation> aggregations;
    private final Set<LocationPrecision> locationPrecisions;
    private final Aggregation minAggregation;
    private final LocationPrecision minLocationPrecision;
    private final Set<String> nodeMetadataPaths;
    private final Set<String> userMetadataPaths;
    private final Set<String> apiPaths;
    private final Instant notAfter;
    private final Boolean refreshAllowed;

    public static Builder builder() {
        return new Builder();
    }

    public BasicSecurityPolicy(Set<Long> nodeIds, Set<String> sourceIds, Set<Aggregation> aggregations, Aggregation minAggregation, Set<LocationPrecision> locationPrecisions, LocationPrecision minLocationPrecision, Set<String> nodeMetadataPaths, Set<String> userMetadataPaths) {
        this(nodeIds, sourceIds, aggregations, minAggregation, locationPrecisions, minLocationPrecision, nodeMetadataPaths, userMetadataPaths, null, null);
    }

    public BasicSecurityPolicy(Set<Long> nodeIds, Set<String> sourceIds, Set<Aggregation> aggregations, Aggregation minAggregation, Set<LocationPrecision> locationPrecisions, LocationPrecision minLocationPrecision, Set<String> nodeMetadataPaths, Set<String> userMetadataPaths, Instant notAfter, Boolean refreshAllowed) {
        this(nodeIds, sourceIds, aggregations, minAggregation, locationPrecisions, minLocationPrecision, nodeMetadataPaths, userMetadataPaths, null, notAfter, refreshAllowed);
    }

    public BasicSecurityPolicy(Set<Long> nodeIds, Set<String> sourceIds, Set<Aggregation> aggregations, Aggregation minAggregation, Set<LocationPrecision> locationPrecisions, LocationPrecision minLocationPrecision, Set<String> nodeMetadataPaths, Set<String> userMetadataPaths, Set<String> apiPaths, Instant notAfter, Boolean refreshAllowed) {
        this.nodeIds = nodeIds;
        this.sourceIds = sourceIds;
        this.aggregations = aggregations;
        this.minAggregation = minAggregation;
        this.locationPrecisions = locationPrecisions;
        this.minLocationPrecision = minLocationPrecision;
        this.nodeMetadataPaths = nodeMetadataPaths;
        this.userMetadataPaths = userMetadataPaths;
        this.apiPaths = apiPaths;
        this.notAfter = notAfter;
        this.refreshAllowed = refreshAllowed;
    }

    @Override
    public Set<Long> getNodeIds() {
        return this.nodeIds;
    }

    @Override
    public Set<String> getSourceIds() {
        return this.sourceIds;
    }

    @Override
    public Set<Aggregation> getAggregations() {
        return this.aggregations;
    }

    @Override
    public Set<LocationPrecision> getLocationPrecisions() {
        return this.locationPrecisions;
    }

    @Override
    public Aggregation getMinAggregation() {
        return this.minAggregation;
    }

    @Override
    public LocationPrecision getMinLocationPrecision() {
        return this.minLocationPrecision;
    }

    @Override
    public Set<String> getNodeMetadataPaths() {
        return this.nodeMetadataPaths;
    }

    @Override
    public Set<String> getUserMetadataPaths() {
        return this.userMetadataPaths;
    }

    @Override
    public Set<String> getApiPaths() {
        return this.apiPaths;
    }

    @Override
    public Instant getNotAfter() {
        return this.notAfter;
    }

    @Override
    public boolean isValidAt(Instant timestamp) {
        return this.notAfter == null || !this.notAfter.isBefore(timestamp != null ? timestamp : Instant.now());
    }

    @Override
    public Boolean getRefreshAllowed() {
        return this.refreshAllowed;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.aggregations == null ? 0 : this.aggregations.hashCode());
        result = 31 * result + (this.locationPrecisions == null ? 0 : this.locationPrecisions.hashCode());
        result = 31 * result + (this.minAggregation == null ? 0 : this.minAggregation.hashCode());
        result = 31 * result + (this.minLocationPrecision == null ? 0 : this.minLocationPrecision.hashCode());
        result = 31 * result + (this.nodeIds == null ? 0 : this.nodeIds.hashCode());
        result = 31 * result + (this.sourceIds == null ? 0 : this.sourceIds.hashCode());
        result = 31 * result + (this.nodeMetadataPaths == null ? 0 : this.nodeMetadataPaths.hashCode());
        result = 31 * result + (this.userMetadataPaths == null ? 0 : this.userMetadataPaths.hashCode());
        result = 31 * result + (this.apiPaths == null ? 0 : this.apiPaths.hashCode());
        result = 31 * result + (this.notAfter == null ? 0 : this.notAfter.hashCode());
        result = 31 * result + (this.refreshAllowed == null ? 0 : this.refreshAllowed.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BasicSecurityPolicy)) {
            return false;
        }
        BasicSecurityPolicy other = (BasicSecurityPolicy)obj;
        if (this.aggregations == null ? other.aggregations != null : !this.aggregations.equals(other.aggregations)) {
            return false;
        }
        if (this.locationPrecisions == null ? other.locationPrecisions != null : !this.locationPrecisions.equals(other.locationPrecisions)) {
            return false;
        }
        if (this.minAggregation != other.minAggregation) {
            return false;
        }
        if (this.minLocationPrecision != other.minLocationPrecision) {
            return false;
        }
        if (this.nodeIds == null ? other.nodeIds != null : !this.nodeIds.equals(other.nodeIds)) {
            return false;
        }
        if (this.sourceIds == null ? other.sourceIds != null : !this.sourceIds.equals(other.sourceIds)) {
            return false;
        }
        if (this.nodeMetadataPaths == null ? other.nodeMetadataPaths != null : !this.nodeMetadataPaths.equals(other.nodeMetadataPaths)) {
            return false;
        }
        if (this.userMetadataPaths == null ? other.userMetadataPaths != null : !this.userMetadataPaths.equals(other.userMetadataPaths)) {
            return false;
        }
        if (this.apiPaths == null ? other.apiPaths != null : !this.apiPaths.equals(other.apiPaths)) {
            return false;
        }
        if (this.notAfter == null ? other.notAfter != null : !this.notAfter.equals(other.notAfter)) {
            return false;
        }
        return !(this.refreshAllowed == null ? other.refreshAllowed != null : !this.refreshAllowed.equals(other.refreshAllowed));
    }

    public String toString() {
        StringBuilder builder2 = new StringBuilder();
        builder2.append("BasicSecurityPolicy{");
        if (this.nodeIds != null) {
            builder2.append("nodeIds=");
            builder2.append(this.nodeIds);
            builder2.append(", ");
        }
        if (this.sourceIds != null) {
            builder2.append("sourceIds=");
            builder2.append(this.sourceIds);
            builder2.append(", ");
        }
        if (this.aggregations != null) {
            builder2.append("aggregations=");
            builder2.append(this.aggregations);
            builder2.append(", ");
        }
        if (this.locationPrecisions != null) {
            builder2.append("locationPrecisions=");
            builder2.append(this.locationPrecisions);
            builder2.append(", ");
        }
        if (this.minAggregation != null) {
            builder2.append("minAggregation=");
            builder2.append(this.minAggregation);
            builder2.append(", ");
        }
        if (this.minLocationPrecision != null) {
            builder2.append("minLocationPrecision=");
            builder2.append((Object)this.minLocationPrecision);
            builder2.append(", ");
        }
        if (this.nodeMetadataPaths != null) {
            builder2.append("nodeMetadataPaths=");
            builder2.append(this.nodeMetadataPaths);
            builder2.append(", ");
        }
        if (this.userMetadataPaths != null) {
            builder2.append("userMetadataPaths=");
            builder2.append(this.userMetadataPaths);
            builder2.append(", ");
        }
        if (this.apiPaths != null) {
            builder2.append("apiPaths=");
            builder2.append(this.apiPaths);
            builder2.append(", ");
        }
        if (this.notAfter != null) {
            builder2.append("notAfter=");
            builder2.append(this.notAfter);
            builder2.append(", ");
        }
        if (this.refreshAllowed != null) {
            builder2.append("refreshAllowed=");
            builder2.append(this.refreshAllowed);
        }
        builder2.append("}");
        return builder2.toString();
    }

    public static class Builder {
        private static final Map<Aggregation, Set<Aggregation>> MAX_AGGREGATION_CACHE = new HashMap<Aggregation, Set<Aggregation>>(16);
        private static final Map<LocationPrecision, Set<LocationPrecision>> MAX_LOCATION_PRECISION_CACHE = new HashMap<LocationPrecision, Set<LocationPrecision>>(16);
        private Set<Long> nodeIds;
        private Set<String> sourceIds;
        private Set<Aggregation> aggregations;
        private Set<LocationPrecision> locationPrecisions;
        private Aggregation minAggregation;
        private LocationPrecision minLocationPrecision;
        private Set<String> nodeMetadataPaths;
        private Set<String> userMetadataPaths;
        private Set<String> apiPaths;
        private Instant notAfter;
        private Boolean refreshAllowed;

        public Builder withPolicy(SecurityPolicy policy) {
            if (policy != null) {
                return this.withAggregations(policy.getAggregations()).withMinAggregation(policy.getMinAggregation()).withLocationPrecisions(policy.getLocationPrecisions()).withMinLocationPrecision(policy.getMinLocationPrecision()).withNodeIds(policy.getNodeIds()).withSourceIds(policy.getSourceIds()).withNodeMetadataPaths(policy.getNodeMetadataPaths()).withUserMetadataPaths(policy.getUserMetadataPaths()).withApiPaths(policy.getApiPaths()).withNotAfter(policy.getNotAfter()).withRefreshAllowed(policy.getRefreshAllowed());
            }
            return this;
        }

        public Builder withMergedPolicy(SecurityPolicy policy) {
            if (policy != null) {
                Builder b = this.withMergedAggregations(policy.getAggregations()).withMergedLocationPrecisions(policy.getLocationPrecisions()).withMergedNodeIds(policy.getNodeIds()).withMergedSourceIds(policy.getSourceIds()).withMergedNodeMetadataPaths(policy.getNodeMetadataPaths()).withMergedUserMetadataPaths(policy.getUserMetadataPaths()).withMergedApiPaths(policy.getApiPaths());
                if (policy.getMinAggregation() != null) {
                    b = b.withMinAggregation(policy.getMinAggregation());
                }
                if (policy.getMinLocationPrecision() != null) {
                    b = b.withMinLocationPrecision(policy.getMinLocationPrecision());
                }
                if (policy.getNotAfter() != null) {
                    b = b.withNotAfter(policy.getNotAfter());
                }
                if (policy.getRefreshAllowed() != null) {
                    b = b.withRefreshAllowed(policy.getRefreshAllowed());
                }
                return b;
            }
            return this;
        }

        public Builder withNodeIds(Set<Long> nodeIds) {
            this.nodeIds = nodeIds == null || nodeIds.isEmpty() ? null : Collections.unmodifiableSet(nodeIds);
            return this;
        }

        public Builder withNodeMetadataPaths(Set<String> nodeMetadataPaths) {
            this.nodeMetadataPaths = nodeMetadataPaths == null || nodeMetadataPaths.isEmpty() ? null : Collections.unmodifiableSet(nodeMetadataPaths);
            return this;
        }

        public Builder withUserMetadataPaths(Set<String> userMetadataPaths) {
            this.userMetadataPaths = userMetadataPaths == null || userMetadataPaths.isEmpty() ? null : Collections.unmodifiableSet(userMetadataPaths);
            return this;
        }

        public Builder withApiPaths(Set<String> apiPaths) {
            this.apiPaths = apiPaths == null || apiPaths.isEmpty() ? null : Collections.unmodifiableSet(apiPaths);
            return this;
        }

        public Builder withSourceIds(Set<String> sourceIds) {
            this.sourceIds = sourceIds == null || sourceIds.isEmpty() ? null : Collections.unmodifiableSet(sourceIds);
            return this;
        }

        public Builder withAggregations(Set<Aggregation> aggregations) {
            this.aggregations = aggregations;
            return this;
        }

        public Builder withLocationPrecisions(Set<LocationPrecision> locationPrecisions) {
            this.locationPrecisions = locationPrecisions;
            return this;
        }

        public Builder withMergedNodeIds(Set<Long> nodeIds) {
            Set<Long> set = nodeIds;
            if (this.nodeIds != null && !this.nodeIds.isEmpty()) {
                set = new LinkedHashSet<Long>(this.nodeIds);
                if (nodeIds != null) {
                    set.addAll(nodeIds);
                }
            }
            return this.withNodeIds(set);
        }

        public Builder withMergedNodeMetadataPaths(Set<String> nodeMetadataPaths) {
            Set<String> set = nodeMetadataPaths;
            if (this.nodeMetadataPaths != null && !this.nodeMetadataPaths.isEmpty()) {
                set = new LinkedHashSet<String>(this.nodeMetadataPaths);
                if (nodeMetadataPaths != null) {
                    set.addAll(nodeMetadataPaths);
                }
            }
            return this.withNodeMetadataPaths(set);
        }

        public Builder withMergedUserMetadataPaths(Set<String> userMetadataPaths) {
            Set<String> set = userMetadataPaths;
            if (this.userMetadataPaths != null && !this.userMetadataPaths.isEmpty()) {
                set = new LinkedHashSet<String>(this.userMetadataPaths);
                if (userMetadataPaths != null) {
                    set.addAll(userMetadataPaths);
                }
            }
            return this.withUserMetadataPaths(set);
        }

        public Builder withMergedApiPaths(Set<String> apiPaths) {
            Set<String> set = apiPaths;
            if (this.apiPaths != null && !this.apiPaths.isEmpty()) {
                set = new LinkedHashSet<String>(this.apiPaths);
                if (apiPaths != null) {
                    set.addAll(apiPaths);
                }
            }
            return this.withApiPaths(set);
        }

        public Builder withMergedSourceIds(Set<String> sourceIds) {
            Set<String> set = sourceIds;
            if (this.sourceIds != null && !this.sourceIds.isEmpty()) {
                set = new LinkedHashSet<String>(this.sourceIds);
                if (sourceIds != null) {
                    set.addAll(sourceIds);
                }
            }
            return this.withSourceIds(set);
        }

        public Builder withMergedAggregations(Set<Aggregation> aggregations) {
            Set<Aggregation> set = aggregations;
            if (this.aggregations != null && !this.aggregations.isEmpty()) {
                if (aggregations != null) {
                    set = new LinkedHashSet<Aggregation>(this.aggregations);
                    set.addAll(aggregations);
                } else {
                    set = this.aggregations;
                }
            }
            return this.withAggregations(set);
        }

        public Builder withMergedLocationPrecisions(Set<LocationPrecision> locationPrecisions) {
            Set<LocationPrecision> set = locationPrecisions;
            if (this.locationPrecisions != null && !this.locationPrecisions.isEmpty()) {
                if (locationPrecisions != null) {
                    set = new LinkedHashSet<LocationPrecision>(this.locationPrecisions);
                    set.addAll(locationPrecisions);
                } else {
                    set = this.locationPrecisions;
                }
            }
            return this.withLocationPrecisions(set);
        }

        public Builder withMinAggregation(Aggregation minAggregation) {
            this.minAggregation = minAggregation;
            return this;
        }

        private Set<Aggregation> buildAggregations() {
            if (this.minAggregation == null && this.aggregations != null && !this.aggregations.isEmpty()) {
                return Collections.unmodifiableSet(this.aggregations);
            }
            if (this.minAggregation == null) {
                return null;
            }
            Set<Aggregation> result = MAX_AGGREGATION_CACHE.get(this.minAggregation);
            if (result != null) {
                return result;
            }
            result = new HashSet<Aggregation>(16);
            for (Aggregation agg : Aggregation.values()) {
                if (agg.compareLevel(this.minAggregation) <= -1) continue;
                result.add(agg);
            }
            result = Collections.unmodifiableSet(EnumSet.copyOf(result));
            MAX_AGGREGATION_CACHE.put(this.minAggregation, result);
            return result;
        }

        public Builder withMinLocationPrecision(LocationPrecision minLocationPrecision) {
            this.minLocationPrecision = minLocationPrecision;
            return this;
        }

        private Set<LocationPrecision> buildLocationPrecisions() {
            if (this.minLocationPrecision == null && this.locationPrecisions != null && !this.locationPrecisions.isEmpty()) {
                return Collections.unmodifiableSet(this.locationPrecisions);
            }
            if (this.minLocationPrecision == null) {
                return null;
            }
            Set<LocationPrecision> result = MAX_LOCATION_PRECISION_CACHE.get((Object)this.minLocationPrecision);
            if (result != null) {
                return result;
            }
            result = new HashSet<LocationPrecision>(16);
            for (LocationPrecision agg : LocationPrecision.values()) {
                if (agg.comparePrecision(this.minLocationPrecision) <= -1) continue;
                result.add(agg);
            }
            result = Collections.unmodifiableSet(EnumSet.copyOf(result));
            MAX_LOCATION_PRECISION_CACHE.put(this.minLocationPrecision, result);
            return result;
        }

        public Builder withNotAfter(Instant date) {
            this.notAfter = date;
            return this;
        }

        public Builder withRefreshAllowed(Boolean refreshAllowed) {
            this.refreshAllowed = refreshAllowed;
            return this;
        }

        public BasicSecurityPolicy build() {
            return new BasicSecurityPolicy(this.nodeIds, this.sourceIds, this.buildAggregations(), this.minAggregation, this.buildLocationPrecisions(), this.minLocationPrecision, this.nodeMetadataPaths, this.userMetadataPaths, this.apiPaths, this.notAfter, this.refreshAllowed);
        }
    }
}

