/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.central.security;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.solarnetwork.central.dao.SolarNodeOwnershipDao;
import net.solarnetwork.central.domain.FilterResults;
import net.solarnetwork.central.domain.SolarNodeOwnership;
import net.solarnetwork.central.security.AuthorizationException;
import net.solarnetwork.central.security.SecurityActor;
import net.solarnetwork.central.security.SecurityException;
import net.solarnetwork.central.security.SecurityNode;
import net.solarnetwork.central.security.SecurityPolicy;
import net.solarnetwork.central.security.SecurityPolicyEnforcer;
import net.solarnetwork.central.security.SecurityPolicyMetadataType;
import net.solarnetwork.central.security.SecurityToken;
import net.solarnetwork.central.security.SecurityTokenType;
import net.solarnetwork.central.security.SecurityUser;
import net.solarnetwork.central.security.SecurityUtils;
import net.solarnetwork.central.support.BasicFilterResults;
import net.solarnetwork.util.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.util.PathMatcher;

public class AuthorizationSupport {
    private final SolarNodeOwnershipDao nodeOwnershipDao;
    private PathMatcher pathMatcher;
    protected final Logger log = LoggerFactory.getLogger(this.getClass());

    public AuthorizationSupport(SolarNodeOwnershipDao nodeOwnershipDao) {
        this.nodeOwnershipDao = (SolarNodeOwnershipDao)ObjectUtils.requireNonNullArgument((Object)nodeOwnershipDao, (String)"nodeOwnershipDao");
    }

    public SolarNodeOwnershipDao getNodeOwnershipDao() {
        return this.nodeOwnershipDao;
    }

    protected void requireNodeWriteAccess(Long nodeId) {
        this.requireNodeWriteAccess(nodeId, this.log);
    }

    public void requireNodeWriteAccess(Long nodeId, Logger log) {
        SecurityToken token;
        SecurityActor actor;
        SolarNodeOwnership ownership = this.nodeOwnershipDao.ownershipForNodeId(nodeId);
        if (ownership == null) {
            log.warn("Access DENIED to node {}; owner not found", (Object)nodeId);
            throw new AuthorizationException(AuthorizationException.Reason.UNKNOWN_OBJECT, nodeId);
        }
        try {
            actor = SecurityUtils.getCurrentActor();
        }
        catch (SecurityException e) {
            log.warn("Access DENIED to node {} for non-authenticated user", (Object)nodeId);
            throw new AuthorizationException(AuthorizationException.Reason.ACCESS_DENIED, nodeId);
        }
        if (actor instanceof SecurityNode) {
            SecurityNode node = (SecurityNode)actor;
            if (ownership.isArchived()) {
                throw new AuthorizationException(AuthorizationException.Reason.UNKNOWN_OBJECT, nodeId);
            }
            if (!nodeId.equals(node.getNodeId())) {
                log.warn("Access DENIED to node {} for node {}; wrong node", (Object)nodeId, (Object)node.getNodeId());
                throw new AuthorizationException(AuthorizationException.Reason.ACCESS_DENIED, nodeId);
            }
            return;
        }
        if (actor instanceof SecurityUser) {
            SecurityUser user = (SecurityUser)actor;
            if (!user.getUserId().equals(ownership.getUserId())) {
                log.warn("Access DENIED to node {} for user {}; wrong user", (Object)nodeId, (Object)user.getEmail());
                throw new AuthorizationException(AuthorizationException.Reason.ACCESS_DENIED, nodeId);
            }
            return;
        }
        if (actor instanceof SecurityToken && SecurityTokenType.User.equals((Object)(token = (SecurityToken)actor).getTokenType())) {
            if (!token.getUserId().equals(ownership.getUserId())) {
                log.warn("Access DENIED to node {} for token {}; wrong user", (Object)nodeId, (Object)token.getToken());
                throw new AuthorizationException(AuthorizationException.Reason.ACCESS_DENIED, nodeId);
            }
            if (token.getPolicy() != null && token.getPolicy().getNodeIds() != null && !token.getPolicy().getNodeIds().contains(nodeId)) {
                log.warn("Access DENIED to node {} for token {}; node not included", (Object)nodeId, (Object)token.getToken());
                throw new AuthorizationException(AuthorizationException.Reason.ACCESS_DENIED, nodeId);
            }
            return;
        }
        log.warn("Access DENIED to node {} for actor {}", (Object)nodeId, (Object)actor);
        throw new AuthorizationException(AuthorizationException.Reason.ACCESS_DENIED, nodeId);
    }

    protected void requireNodeReadAccess(Long nodeId) {
        this.requireNodeReadAccess(nodeId, this.log);
    }

    public void requireNodeReadAccess(Long nodeId, Logger log) {
        SecurityActor actor;
        SolarNodeOwnership ownership = this.nodeOwnershipDao.ownershipForNodeId(nodeId);
        if (ownership == null) {
            log.warn("Access DENIED to node {}; owner not found", (Object)nodeId);
            throw new AuthorizationException(AuthorizationException.Reason.UNKNOWN_OBJECT, nodeId);
        }
        if (!ownership.isRequiresAuthorization()) {
            return;
        }
        try {
            actor = SecurityUtils.getCurrentActor();
        }
        catch (SecurityException e) {
            log.warn("Access DENIED to node {} for non-authenticated user", (Object)nodeId);
            throw new AuthorizationException(AuthorizationException.Reason.ACCESS_DENIED, nodeId);
        }
        if (actor instanceof SecurityNode) {
            SecurityNode node = (SecurityNode)actor;
            if (ownership.isArchived()) {
                throw new AuthorizationException(AuthorizationException.Reason.UNKNOWN_OBJECT, nodeId);
            }
            if (!nodeId.equals(node.getNodeId())) {
                log.warn("Access DENIED to node {} for node {}; wrong node", (Object)nodeId, (Object)node.getNodeId());
                throw new AuthorizationException(AuthorizationException.Reason.ACCESS_DENIED, nodeId);
            }
            return;
        }
        if (actor instanceof SecurityUser) {
            SecurityUser user = (SecurityUser)actor;
            if (!user.getUserId().equals(ownership.getUserId())) {
                log.warn("Access DENIED to node {} for user {}; wrong user", (Object)nodeId, (Object)user.getEmail());
                throw new AuthorizationException(AuthorizationException.Reason.ACCESS_DENIED, nodeId);
            }
            return;
        }
        if (actor instanceof SecurityToken) {
            SecurityToken token = (SecurityToken)actor;
            if (SecurityTokenType.ReadNodeData.equals((Object)token.getTokenType()) && ownership.isArchived()) {
                throw new AuthorizationException(AuthorizationException.Reason.UNKNOWN_OBJECT, nodeId);
            }
            if (!token.getUserId().equals(ownership.getUserId())) {
                log.warn("Access DENIED to node {} for token {}; wrong user", (Object)nodeId, (Object)token.getToken());
                throw new AuthorizationException(AuthorizationException.Reason.ACCESS_DENIED, nodeId);
            }
            if (token.getPolicy() != null && token.getPolicy().getNodeIds() != null && !token.getPolicy().getNodeIds().contains(nodeId)) {
                log.warn("Access DENIED to node {} for token {}; node not included", (Object)nodeId, (Object)token.getToken());
                throw new AuthorizationException(AuthorizationException.Reason.ACCESS_DENIED, nodeId);
            }
            return;
        }
        log.warn("Access DENIED to node {} for actor {}", (Object)nodeId, (Object)actor);
        throw new AuthorizationException(AuthorizationException.Reason.ACCESS_DENIED, nodeId);
    }

    protected void requireUserWriteAccess(Long userId) {
        this.requireUserWriteAccess(userId, this.log);
    }

    public void requireUserWriteAccess(Long userId, Logger log) {
        SecurityToken token;
        SecurityActor actor;
        try {
            actor = SecurityUtils.getCurrentActor();
        }
        catch (SecurityException e) {
            log.warn("Access DENIED to user {} for non-authenticated user", (Object)userId);
            throw new AuthorizationException(AuthorizationException.Reason.ACCESS_DENIED, userId);
        }
        if (actor instanceof SecurityUser) {
            SecurityUser user = (SecurityUser)actor;
            if (!user.getUserId().equals(userId)) {
                log.warn("Access DENIED to user {} for user {}; wrong user", (Object)userId, (Object)user.getEmail());
                throw new AuthorizationException(AuthorizationException.Reason.ACCESS_DENIED, userId);
            }
            return;
        }
        if (actor instanceof SecurityToken && SecurityTokenType.User.equals((Object)(token = (SecurityToken)actor).getTokenType())) {
            if (!token.getUserId().equals(userId)) {
                log.warn("Access DENIED to user {} for token {}; wrong user", (Object)userId, (Object)token.getToken());
                throw new AuthorizationException(AuthorizationException.Reason.ACCESS_DENIED, userId);
            }
            return;
        }
        log.warn("Access DENIED to user {} for actor {}", (Object)userId, (Object)actor);
        throw new AuthorizationException(AuthorizationException.Reason.ACCESS_DENIED, userId);
    }

    public SecurityPolicy getActiveSecurityPolicy() {
        return SecurityUtils.getActiveSecurityPolicy();
    }

    protected void requireUserReadAccess(Long userId) {
        this.requireUserReadAccess(userId, this.log);
    }

    public void requireUserReadAccess(Long userId, Logger log) {
        SecurityActor actor;
        try {
            actor = SecurityUtils.getCurrentActor();
        }
        catch (SecurityException e) {
            log.warn("Access DENIED to user {} for non-authenticated user", (Object)userId);
            throw new AuthorizationException(AuthorizationException.Reason.ACCESS_DENIED, userId);
        }
        if (actor instanceof SecurityNode) {
            SolarNodeOwnership ownership;
            SecurityNode node = (SecurityNode)actor;
            SolarNodeOwnership solarNodeOwnership = ownership = node.getNodeId() != null ? this.nodeOwnershipDao.ownershipForNodeId(node.getNodeId()) : null;
            if (ownership == null) {
                log.warn("Access DENIED to user {} for node {}; not found", (Object)userId, (Object)node.getNodeId());
                throw new AuthorizationException(AuthorizationException.Reason.UNKNOWN_OBJECT, userId);
            }
            if (!userId.equals(ownership.getUserId())) {
                log.warn("Access DENIED to user {} for node {}; wrong node", (Object)userId, (Object)node.getNodeId());
                throw new AuthorizationException(AuthorizationException.Reason.ACCESS_DENIED, userId);
            }
            return;
        }
        if (actor instanceof SecurityUser) {
            SecurityUser user = (SecurityUser)actor;
            if (!user.getUserId().equals(userId)) {
                log.warn("Access DENIED to user {} for user {}; wrong user", (Object)userId, (Object)user.getEmail());
                throw new AuthorizationException(AuthorizationException.Reason.ACCESS_DENIED, userId);
            }
            return;
        }
        if (actor instanceof SecurityToken) {
            SecurityToken token = (SecurityToken)actor;
            if (!token.getUserId().equals(userId)) {
                log.warn("Access DENIED to user {} for token {}; wrong user", (Object)userId, (Object)token.getToken());
                throw new AuthorizationException(AuthorizationException.Reason.ACCESS_DENIED, userId);
            }
            if (SecurityTokenType.ReadNodeData.equals((Object)token.getTokenType()) && (token.getPolicy() == null || token.getPolicy().getUserMetadataPaths() == null || token.getPolicy().getUserMetadataPaths().isEmpty())) {
                log.warn("Access DENIED to user {} for token {}; user metadata not included in policy", (Object)userId, (Object)token.getToken());
                throw new AuthorizationException(AuthorizationException.Reason.ACCESS_DENIED, userId);
            }
            return;
        }
        log.warn("Access DENIED to user {} for actor {}", (Object)userId, (Object)actor);
        throw new AuthorizationException(AuthorizationException.Reason.ACCESS_DENIED, userId);
    }

    public <T> T policyEnforcerCheck(T domainObject) {
        return this.policyEnforcerCheck(domainObject, SecurityPolicyMetadataType.Node);
    }

    public <T> T policyEnforcerCheck(T domainObject, SecurityPolicyMetadataType metadataType) {
        Object principal;
        Authentication authentication = SecurityUtils.getCurrentAuthentication();
        SecurityPolicy policy = this.getActiveSecurityPolicy();
        if (policy == null || domainObject == null) {
            return domainObject;
        }
        Object object = principal = authentication != null ? authentication.getPrincipal() : null;
        if (domainObject instanceof FilterResults) {
            FilterResults filterResults = (FilterResults)domainObject;
            Collection<Object> filteredObjects = this.policyEnforcedCollection(filterResults, policy, principal, metadataType);
            BasicFilterResults<Object> result = new BasicFilterResults<Object>(filteredObjects, filterResults.getTotalResults(), filterResults.getStartingOffset(), filterResults.getReturnedResultCount());
            return (T)result;
        }
        if (domainObject instanceof List) {
            List collectionResults = (List)domainObject;
            Collection<Object> filteredObjects = this.policyEnforcedCollection(collectionResults, policy, principal, metadataType);
            return (T)filteredObjects;
        }
        SecurityPolicyEnforcer enforcer = new SecurityPolicyEnforcer(policy, authentication != null ? authentication.getPrincipal() : null, domainObject, this.pathMatcher, metadataType);
        enforcer.verify();
        return SecurityPolicyEnforcer.createSecurityPolicyProxy(enforcer);
    }

    private Collection<Object> policyEnforcedCollection(Iterable<?> input, SecurityPolicy policy, Object principal, SecurityPolicyMetadataType metadataType) {
        if (input == null) {
            return null;
        }
        ArrayList<Object> enforced = new ArrayList<Object>();
        for (Object obj : input) {
            SecurityPolicyEnforcer enforcer = new SecurityPolicyEnforcer(policy, principal, obj, this.pathMatcher, metadataType);
            enforcer.verify();
            enforced.add(SecurityPolicyEnforcer.createSecurityPolicyProxy(enforcer));
        }
        return enforced;
    }

    public PathMatcher getPathMatcher() {
        return this.pathMatcher;
    }

    public void setPathMatcher(PathMatcher pathMatcher) {
        this.pathMatcher = pathMatcher;
    }
}

