/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.central.security;

import net.solarnetwork.central.security.SecurityPolicy;
import net.solarnetwork.central.security.SecurityToken;
import net.solarnetwork.central.security.SecurityTokenType;
import net.solarnetwork.util.ObjectUtils;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.core.userdetails.UserDetails;

public class AuthenticatedToken
extends User
implements SecurityToken {
    private static final long serialVersionUID = -4857188995583662187L;
    private final SecurityTokenType tokenType;
    private final Long userId;
    private final SecurityPolicy policy;

    public AuthenticatedToken(UserDetails user, SecurityTokenType tokenType, Long userId, SecurityPolicy policy) {
        super(((UserDetails)ObjectUtils.requireNonNullArgument((Object)user, (String)"user")).getUsername(), user.getPassword(), user.isEnabled(), user.isAccountNonExpired(), user.isCredentialsNonExpired(), user.isAccountNonLocked(), user.getAuthorities());
        this.tokenType = (SecurityTokenType)((Object)ObjectUtils.requireNonNullArgument((Object)((Object)tokenType), (String)"tokenType"));
        this.userId = (Long)ObjectUtils.requireNonNullArgument((Object)userId, (String)"userId");
        this.policy = policy;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder("AuthenticatedToken{type=");
        buf.append((Object)this.tokenType);
        buf.append(",token=");
        buf.append(this.getToken());
        buf.append(",userId=");
        buf.append(this.userId);
        if (this.policy != null) {
            buf.append(",policy=");
            buf.append(this.policy);
        }
        buf.append("}");
        return buf.toString();
    }

    @Override
    public boolean isAuthenticatedWithToken() {
        return true;
    }

    @Override
    public Long getUserId() {
        return this.userId;
    }

    @Override
    public String getToken() {
        return this.getUsername();
    }

    @Override
    public SecurityTokenType getTokenType() {
        return this.tokenType;
    }

    @Override
    public SecurityPolicy getPolicy() {
        return this.policy;
    }
}

