/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.central.scheduler;

import java.time.Instant;
import java.util.TreeMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import net.solarnetwork.domain.datum.AggregateDatumSamples;
import net.solarnetwork.domain.datum.DatumSamples;
import net.solarnetwork.service.PingTest;
import net.solarnetwork.service.PingTestResult;
import net.solarnetwork.util.ObjectUtils;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;

public class ThreadPoolTaskSchedulerPingTest
implements PingTest {
    private final String id;
    private final ThreadPoolTaskScheduler scheduler;
    private final AggregateDatumSamples stats = new AggregateDatumSamples(Instant.now());
    private static final String ACTIVE_COUNT = "active";
    private static final String ACTIVE_COUNT_AVG = "active_avg";
    private static final String CORE_SIZE = "core-size";
    private static final String CORE_SIZE_AVG = "core-size_avg";
    private static final String POOL_SIZE = "size";
    private static final String POOL_SIZE_AVG = "size_avg";
    private static final String QUEUE_SIZE = "queue-size";
    private static final String QUEUE_SIZE_AVG = "queue-size_avg";

    public ThreadPoolTaskSchedulerPingTest(ThreadPoolTaskScheduler scheduler) {
        this(ThreadPoolTaskSchedulerPingTest.defaultId(scheduler), scheduler);
    }

    private static String defaultId(ThreadPoolTaskScheduler executor) {
        Object id = ThreadPoolTaskSchedulerPingTest.class.getName();
        if (((ThreadPoolTaskScheduler)ObjectUtils.requireNonNullArgument((Object)executor, (String)"executor")).getThreadNamePrefix() != null) {
            String prefix = executor.getThreadNamePrefix().trim();
            id = prefix.endsWith("-") ? (String)id + "-" + prefix.substring(0, prefix.length() - 1) : (String)id + prefix;
        }
        return id;
    }

    public ThreadPoolTaskSchedulerPingTest(String id, ThreadPoolTaskScheduler scheduler) {
        this.id = (String)ObjectUtils.requireNonNullArgument((Object)id, (String)"id");
        this.scheduler = (ThreadPoolTaskScheduler)ObjectUtils.requireNonNullArgument((Object)scheduler, (String)"scheduler");
    }

    public String getPingTestId() {
        return this.id;
    }

    public String getPingTestName() {
        return "Thread Pool Scheduler";
    }

    public long getPingTestMaximumExecutionMilliseconds() {
        return 1000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PingTest.Result performPingTest() throws Exception {
        DatumSamples avg;
        ScheduledThreadPoolExecutor e;
        ScheduledExecutorService service = this.scheduler.getScheduledExecutor();
        ScheduledThreadPoolExecutor executor = service instanceof ScheduledThreadPoolExecutor ? (e = (ScheduledThreadPoolExecutor)service) : null;
        int activeCount = this.scheduler.getActiveCount();
        int coreSize = executor != null ? executor.getCorePoolSize() : 0;
        int poolSize = this.scheduler.getPoolSize();
        int queueSize = executor != null ? executor.getQueue().size() : 0;
        AggregateDatumSamples aggregateDatumSamples = this.stats;
        synchronized (aggregateDatumSamples) {
            this.stats.putInstantaneousSampleValue(ACTIVE_COUNT, (Number)activeCount);
            this.stats.putInstantaneousSampleValue(CORE_SIZE, (Number)coreSize);
            this.stats.putInstantaneousSampleValue(POOL_SIZE, (Number)poolSize);
            this.stats.putInstantaneousSampleValue(QUEUE_SIZE, (Number)queueSize);
            avg = this.stats.average(1, "%s_min", "%s_max");
        }
        TreeMap props = new TreeMap(avg.getSampleData());
        props.put(ACTIVE_COUNT_AVG, props.get(ACTIVE_COUNT));
        props.put(ACTIVE_COUNT, activeCount);
        props.put(CORE_SIZE_AVG, props.get(CORE_SIZE));
        props.put(CORE_SIZE, coreSize);
        props.put(POOL_SIZE_AVG, props.get(POOL_SIZE));
        props.put(POOL_SIZE, poolSize);
        props.put(QUEUE_SIZE_AVG, props.get(QUEUE_SIZE));
        props.put(QUEUE_SIZE, queueSize);
        return new PingTestResult(true, null, props);
    }
}

