/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.central.scheduler;

import java.time.Instant;
import java.util.TreeMap;
import net.solarnetwork.domain.datum.AggregateDatumSamples;
import net.solarnetwork.domain.datum.DatumSamples;
import net.solarnetwork.service.PingTest;
import net.solarnetwork.service.PingTestResult;
import net.solarnetwork.util.ObjectUtils;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

public class ThreadPoolTaskExecutorPingTest
implements PingTest {
    private final String id;
    private final ThreadPoolTaskExecutor executor;
    private final AggregateDatumSamples stats = new AggregateDatumSamples(Instant.now());
    private static final String ACTIVE_COUNT = "active";
    private static final String ACTIVE_COUNT_AVG = "active_avg";
    private static final String CORE_SIZE = "core-size";
    private static final String CORE_SIZE_AVG = "core-size_avg";
    private static final String POOL_SIZE = "size";
    private static final String POOL_SIZE_AVG = "size_avg";
    private static final String QUEUE_SIZE = "queue-size";
    private static final String QUEUE_SIZE_AVG = "queue-size_avg";
    private static final String QUEUE_CAPACITY = "queue-capacity";

    public ThreadPoolTaskExecutorPingTest(ThreadPoolTaskExecutor executor) {
        this(ThreadPoolTaskExecutorPingTest.defaultId(executor), executor);
    }

    private static String defaultId(ThreadPoolTaskExecutor executor) {
        Object id = ThreadPoolTaskExecutorPingTest.class.getName();
        if (((ThreadPoolTaskExecutor)ObjectUtils.requireNonNullArgument((Object)executor, (String)"executor")).getThreadNamePrefix() != null) {
            String prefix = executor.getThreadNamePrefix().trim();
            id = prefix.endsWith("-") ? (String)id + "-" + prefix.substring(0, prefix.length() - 1) : (String)id + prefix;
        }
        return id;
    }

    public ThreadPoolTaskExecutorPingTest(String id, ThreadPoolTaskExecutor executor) {
        this.id = (String)ObjectUtils.requireNonNullArgument((Object)id, (String)"id");
        this.executor = (ThreadPoolTaskExecutor)ObjectUtils.requireNonNullArgument((Object)executor, (String)"executor");
    }

    public String getPingTestId() {
        return this.id;
    }

    public String getPingTestName() {
        return "Thread Pool Executor";
    }

    public long getPingTestMaximumExecutionMilliseconds() {
        return 1000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PingTest.Result performPingTest() throws Exception {
        DatumSamples avg;
        int activeCount = this.executor.getActiveCount();
        int coreSize = this.executor.getCorePoolSize();
        int poolSize = this.executor.getPoolSize();
        int queueCapacity = this.executor.getQueueCapacity();
        int queueSize = this.executor.getQueueSize();
        AggregateDatumSamples aggregateDatumSamples = this.stats;
        synchronized (aggregateDatumSamples) {
            this.stats.putInstantaneousSampleValue(ACTIVE_COUNT, (Number)activeCount);
            this.stats.putInstantaneousSampleValue(CORE_SIZE, (Number)coreSize);
            this.stats.putInstantaneousSampleValue(POOL_SIZE, (Number)poolSize);
            this.stats.putInstantaneousSampleValue(QUEUE_SIZE, (Number)queueSize);
            this.stats.putStatusSampleValue(QUEUE_CAPACITY, (Object)queueCapacity);
            avg = this.stats.average(1, "%s_min", "%s_max");
        }
        TreeMap props = new TreeMap(avg.getSampleData());
        props.put(ACTIVE_COUNT_AVG, props.get(ACTIVE_COUNT));
        props.put(ACTIVE_COUNT, activeCount);
        props.put(CORE_SIZE_AVG, props.get(CORE_SIZE));
        props.put(CORE_SIZE, coreSize);
        props.put(POOL_SIZE_AVG, props.get(POOL_SIZE));
        props.put(POOL_SIZE, poolSize);
        props.put(QUEUE_SIZE_AVG, props.get(QUEUE_SIZE));
        props.put(QUEUE_SIZE, queueSize);
        return new PingTestResult(true, null, props);
    }
}

