/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.central.scheduler;

import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ScheduledFuture;
import net.solarnetwork.central.scheduler.JobInfo;
import net.solarnetwork.central.scheduler.JobKey;
import net.solarnetwork.central.scheduler.JobStatus;
import net.solarnetwork.central.scheduler.ScheduledJob;
import net.solarnetwork.central.scheduler.SchedulerManager;
import net.solarnetwork.central.scheduler.SchedulerStatus;
import net.solarnetwork.central.scheduler.SchedulerUtils;
import net.solarnetwork.service.PingTest;
import net.solarnetwork.service.PingTestResult;
import net.solarnetwork.service.ServiceLifecycleObserver;
import net.solarnetwork.util.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.Trigger;

public class SimpleSchedulerManager
implements SchedulerManager,
PingTest,
ServiceLifecycleObserver {
    public static final long DEFUALT_PING_TEST_MAX_EXECUTION = 2000L;
    public static final long DEFAULT_BLOCKED_JOB_MAX_SECONDS = 1800L;
    private static final Logger log = LoggerFactory.getLogger(SimpleSchedulerManager.class);
    private final ConcurrentNavigableMap<JobKey, ScheduledJob> jobs = new ConcurrentSkipListMap<JobKey, ScheduledJob>();
    private final TaskScheduler taskScheduler;
    private long blockedJobMaxSeconds = 1800L;
    private long pingTestMaximumExecutionMilliseconds = 2000L;
    private SchedulerStatus status = SchedulerStatus.Starting;

    public SimpleSchedulerManager(TaskScheduler taskScheduler) {
        this.taskScheduler = (TaskScheduler)ObjectUtils.requireNonNullArgument((Object)taskScheduler, (String)"taskScheduler");
    }

    public void serviceDidStartup() {
        this.status = SchedulerStatus.Running;
    }

    public void serviceDidShutdown() {
        this.status = SchedulerStatus.Destroyed;
    }

    @Override
    public SchedulerStatus currentStatus() {
        return this.status;
    }

    @Override
    public void updateStatus(SchedulerStatus desiredStatus) {
        this.status = desiredStatus;
    }

    @Override
    public Collection<JobInfo> allJobInfos() {
        return new ArrayList<JobInfo>(this.jobs.values());
    }

    @Override
    public void pauseJob(String groupId, String id) {
        ScheduledJob job = (ScheduledJob)this.jobs.get(new JobKey(groupId, id));
        if (job != null) {
            job.setPaused(true);
        }
    }

    @Override
    public void resumeJob(String groupId, String id) {
        ScheduledJob job = (ScheduledJob)this.jobs.get(new JobKey(groupId, id));
        if (job != null) {
            job.setPaused(false);
        }
    }

    @Override
    public synchronized ScheduledFuture<?> scheduleJob(String groupId, String id, Runnable task, Trigger trigger) {
        try {
            JobKey key = new JobKey(groupId, id);
            this.unscheduleJob(key);
            log.info("Scheduling job {} @ {}", (Object)key.getDescription(), (Object)SchedulerUtils.extractExecutionScheduleDescription(trigger));
            ScheduledJob job = new ScheduledJob(key, task, trigger);
            ScheduledFuture f = this.taskScheduler.schedule((Runnable)job, trigger);
            job.setFuture(f);
            this.jobs.put(key, job);
            return f;
        }
        catch (Exception e) {
            log.error("Error scheduling job [{}.{}]: {}", new Object[]{groupId, id, e.toString(), e});
            throw e;
        }
    }

    @Override
    public synchronized boolean unscheduleJob(String groupId, String id) {
        JobKey key = new JobKey(groupId, id);
        return this.unscheduleJob(key);
    }

    private synchronized boolean unscheduleJob(JobKey key) {
        ScheduledJob job = (ScheduledJob)this.jobs.get(key);
        if (job != null) {
            log.info("Unscheduling job {}", (Object)key.getDescription());
            job.setPaused(true);
            ScheduledFuture<?> f = job.getFuture();
            if (f != null) {
                f.cancel(false);
                job.setFuture(null);
            }
        }
        return job != null;
    }

    public String getPingTestId() {
        return this.getClass().getName();
    }

    public String getPingTestName() {
        return "Job Scheduler";
    }

    public long getPingTestMaximumExecutionMilliseconds() {
        return this.pingTestMaximumExecutionMilliseconds;
    }

    public PingTest.Result performPingTest() throws Exception {
        if (this.status == SchedulerStatus.Paused) {
            return new PingTestResult(false, "Scheduler is paused");
        }
        if (this.status == SchedulerStatus.Destroyed) {
            return new PingTestResult(false, "Scheduler is shut down");
        }
        int triggerCount = 0;
        String stateErrorTemplate = "Trigger %s.%s is in the %s state, since %s.";
        for (Map.Entry entry : this.jobs.entrySet()) {
            String sinceTime;
            JobKey key = (JobKey)entry.getKey();
            ScheduledJob job = (ScheduledJob)entry.getValue();
            ++triggerCount;
            JobStatus triggerState = job.getJobStatus();
            Instant lastFireTime = job.getPreviousExecutionTime();
            String string = sinceTime = lastFireTime != null ? DateTimeFormatter.ISO_INSTANT.format(lastFireTime) : "";
            if (triggerState == JobStatus.Error) {
                return new PingTestResult(false, String.format("Trigger %s.%s is in the %s state, since %s.", key.getGroupId(), key.getId(), "ERROR", sinceTime));
            }
            if (!job.isExecuting() || System.currentTimeMillis() - lastFireTime.toEpochMilli() <= this.blockedJobMaxSeconds * 1000L) continue;
            return new PingTestResult(false, String.format("Trigger %s.%s is in the %s state, since %s.", key.getGroupId(), key.getId(), "BLOCKED", sinceTime));
        }
        String msg = String.format("Scheduler is running as expected; %d triggers configured.", triggerCount);
        return new PingTestResult(true, msg);
    }

    public long getBlockedJobMaxSeconds() {
        return this.blockedJobMaxSeconds;
    }

    public void setBlockedJobMaxSeconds(long blockedJobMaxSeconds) {
        this.blockedJobMaxSeconds = blockedJobMaxSeconds;
    }

    public void setPingTestMaximumExecutionMilliseconds(long pingTestMaximumExecutionMilliseconds) {
        this.pingTestMaximumExecutionMilliseconds = pingTestMaximumExecutionMilliseconds;
    }
}

