/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.central.scheduler;

import com.cronutils.descriptor.CronDescriptor;
import com.cronutils.model.Cron;
import com.cronutils.model.CronType;
import com.cronutils.model.definition.CronDefinitionBuilder;
import com.cronutils.parser.CronParser;
import java.security.SecureRandom;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.Trigger;
import org.springframework.scheduling.support.CronTrigger;
import org.springframework.scheduling.support.PeriodicTrigger;

public final class SchedulerUtils {
    public static final Pattern CRON_PLAIN_SECOND_FIELD_PATTERN = Pattern.compile("^\\s*\\d+(?=\\s+)");
    private static final Logger log = LoggerFactory.getLogger(SchedulerUtils.class);

    private SchedulerUtils() {
    }

    public static Trigger triggerForExpression(String expression, TimeUnit timeUnit, boolean randomized) {
        if (expression != null) {
            try {
                try {
                    long frequency = Long.parseLong(expression);
                    PeriodicTrigger trigger = new PeriodicTrigger(Duration.of(frequency, timeUnit.toChronoUnit()));
                    trigger.setFixedRate(true);
                    return trigger;
                }
                catch (NumberFormatException frequency) {
                    Matcher m;
                    Object cronExpr = expression;
                    if (randomized && (m = CRON_PLAIN_SECOND_FIELD_PATTERN.matcher(expression)).find()) {
                        int randSec = new SecureRandom().nextInt(60);
                        cronExpr = String.valueOf(randSec) + expression.substring(m.end());
                    }
                    return new CronTrigger((String)cronExpr);
                }
            }
            catch (IllegalArgumentException e) {
                log.warn("Error parsing cron expression [{}]: {}", (Object)expression, (Object)e.getMessage());
            }
        }
        return null;
    }

    public static final String extractExecutionScheduleDescription(Trigger trigger) {
        if (trigger instanceof CronTrigger) {
            CronTrigger cronTrigger = (CronTrigger)trigger;
            try {
                Cron cron = new CronParser(CronDefinitionBuilder.instanceDefinitionFor((CronType)CronType.SPRING)).parse(cronTrigger.getExpression());
                CronDescriptor desc = CronDescriptor.instance();
                return desc.describe(cron);
            }
            catch (IllegalArgumentException e) {
                return "cron: " + cronTrigger.getExpression();
            }
        }
        if (trigger instanceof PeriodicTrigger) {
            PeriodicTrigger calTrigger = (PeriodicTrigger)trigger;
            return String.format("every %s (%s)", calTrigger.getPeriodDuration(), calTrigger.isFixedRate() ? "fix" : "delay");
        }
        return "Unknown schedule: " + trigger.toString();
    }
}

