/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.central.scheduler;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.time.Instant;
import java.util.concurrent.ScheduledFuture;
import net.solarnetwork.central.scheduler.BasicJobInfo;
import net.solarnetwork.central.scheduler.JobKey;
import net.solarnetwork.central.scheduler.JobStatus;
import net.solarnetwork.central.scheduler.SchedulerUtils;
import net.solarnetwork.util.ObjectUtils;
import org.springframework.scheduling.Trigger;
import org.springframework.scheduling.TriggerContext;
import org.springframework.scheduling.support.SimpleTriggerContext;

public class ScheduledJob
extends BasicJobInfo
implements Runnable {
    private final JobKey key;
    private final Runnable task;
    private final Trigger trigger;
    private ScheduledFuture<?> future;
    private volatile boolean paused = false;
    private volatile Throwable exception;
    private volatile Instant lastActualExecutionTime;
    private volatile Instant lastCompletionTime;

    public ScheduledJob(JobKey key, Runnable task, Trigger trigger) {
        super(((JobKey)ObjectUtils.requireNonNullArgument((Object)key, (String)"key")).getGroupId(), key.getId(), SchedulerUtils.extractExecutionScheduleDescription((Trigger)ObjectUtils.requireNonNullArgument((Object)trigger, (String)"trigger")));
        this.key = key;
        this.task = (Runnable)ObjectUtils.requireNonNullArgument((Object)task, (String)"task");
        this.trigger = trigger;
    }

    @Override
    public void run() {
        if (this.paused) {
            return;
        }
        this.lastActualExecutionTime = Instant.now();
        this.exception = null;
        try {
            this.task.run();
        }
        catch (Exception e) {
            this.exception = e;
            throw e;
        }
        finally {
            this.lastCompletionTime = Instant.now();
        }
    }

    @Override
    public JobStatus getJobStatus() {
        if (this.exception != null) {
            return JobStatus.Error;
        }
        if (this.paused) {
            return JobStatus.Paused;
        }
        return JobStatus.Scheduled;
    }

    @Override
    public boolean isExecuting() {
        Instant lastStart = this.getPreviousExecutionTime();
        Instant lastComplete = this.getLastCompletionTime();
        return lastStart != null && (lastComplete == null || lastComplete.isBefore(lastStart));
    }

    @Override
    public Instant getPreviousExecutionTime() {
        return this.lastActualExecutionTime;
    }

    @Override
    public Instant getNextExecutionTime() {
        if (this.paused) {
            return null;
        }
        Instant lastStart = this.getPreviousExecutionTime();
        Instant lastComplete = this.getLastCompletionTime();
        return this.trigger.nextExecution((TriggerContext)new SimpleTriggerContext(null, lastStart, lastComplete));
    }

    @JsonIgnore
    public JobKey getKey() {
        return this.key;
    }

    public Trigger getTrigger() {
        return this.trigger;
    }

    public Instant getLastCompletionTime() {
        return this.lastCompletionTime;
    }

    public boolean isPaused() {
        return this.paused;
    }

    public void setPaused(boolean paused) {
        this.paused = paused;
    }

    @JsonIgnore
    public ScheduledFuture<?> getFuture() {
        return this.future;
    }

    public void setFuture(ScheduledFuture<?> future) {
        this.future = future;
    }
}

