/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.central.scheduler;

import java.util.ArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import net.solarnetwork.central.scheduler.ManagedJob;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.task.AsyncTaskExecutor;

public abstract class JobSupport
implements ManagedJob {
    public static final long DEFAULT_MAX_WAIT = 900000L;
    public static final String DEFAULT_CRON = "0 0/1 * * * ?";
    public static final int DEFAULT_MAX_ITERATIONS = 1000;
    public static final int DEFAULT_PARALLELISM = 1;
    public static final long DEFAULT_JITTER = 500L;
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private long maximumWaitMs = 900000L;
    private String id;
    private String groupId;
    private String schedule = "0 0/1 * * * ?";
    private AsyncTaskExecutor parallelTaskExecutor = null;
    private int maximumIterations = 1000;
    private int parallelism = 1;
    private long jitter = 500L;

    private AsyncTaskExecutor taskExecutorForParallelTasks() {
        AsyncTaskExecutor s = this.getParallelTaskExecutor();
        if (s == null) {
            throw new RuntimeException("No AsyncTaskExecutor is configured for parallel tasks.");
        }
        return s;
    }

    protected final boolean executeParallelJob(final String taskName) {
        int tCount = this.getParallelism();
        final int tIterations = this.getMaximumIterations();
        this.log.debug("Processing at most {} {} iterations using {} threads", new Object[]{tIterations, taskName, tCount});
        final AtomicInteger remainingCount = new AtomicInteger(tIterations);
        boolean allDone = false;
        if (tCount > 1) {
            AsyncTaskExecutor executorService = this.taskExecutorForParallelTasks();
            final CountDownLatch latch = new CountDownLatch(tCount);
            final long tJitter = this.getJitter();
            ArrayList<Future> futures = new ArrayList<Future>();
            for (int i = 0; i < tCount; ++i) {
                try {
                    futures.add(executorService.submit(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            long delay;
                            if (tJitter > 0L && (delay = (long)Math.ceil(Math.random() * (double)tJitter)) > 0L) {
                                JobSupport.this.log.debug("Delaying thread {} start of processing {} by jitter of {}ms", new Object[]{Thread.currentThread().getName(), taskName, delay});
                                try {
                                    Thread.sleep(delay);
                                }
                                catch (InterruptedException interruptedException) {
                                    // empty catch block
                                }
                            }
                            JobSupport.this.log.debug("Thread {} processing at most {} {} iterations", new Object[]{Thread.currentThread().getName(), tIterations, taskName});
                            try {
                                int processedCount = JobSupport.this.executeJobTask(remainingCount);
                                JobSupport.this.log.debug("Thread {} processed {} {} iterations", new Object[]{Thread.currentThread().getName(), processedCount, taskName});
                            }
                            catch (Exception e) {
                                Throwable root = e;
                                while (root.getCause() != null) {
                                    root = root.getCause();
                                }
                                JobSupport.this.log.error("Error processing {} iteration: {}", new Object[]{taskName, e.toString(), root});
                            }
                            finally {
                                latch.countDown();
                            }
                        }
                    }));
                    continue;
                }
                catch (RejectedExecutionException e) {
                    latch.countDown();
                    this.log.warn("Unable to process {}: queue full", (Object)taskName);
                }
            }
            try {
                allDone = latch.await(this.getMaximumWaitMs(), TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!allDone) {
                this.log.warn("Timeout processing {} iterations; {}/{} tasks completed", new Object[]{taskName, (long)tCount - latch.getCount(), tCount});
                for (Future f : futures) {
                    try {
                        if (!f.cancel(false)) continue;
                        this.log.info("Cancelled task {}", (Object)taskName);
                    }
                    catch (Exception e) {
                        this.log.warn("Error cancelling task {}: {}", (Object)taskName, (Object)e.toString());
                    }
                }
            }
        } else {
            try {
                this.executeJobTask(remainingCount);
            }
            catch (Exception e) {
                Throwable root = e;
                while (root.getCause() != null) {
                    root = root.getCause();
                }
                this.log.error("Error processing {} iteration: {}", new Object[]{taskName, e.toString(), root});
            }
            allDone = true;
        }
        return allDone;
    }

    protected int executeJobTask(AtomicInteger remainingIterataions) throws Exception {
        throw new UnsupportedOperationException("Extending class must implement.");
    }

    @Override
    public String getId() {
        return this.id;
    }

    public void setId(String jobId) {
        this.id = jobId;
    }

    public long getMaximumWaitMs() {
        return this.maximumWaitMs;
    }

    public void setMaximumWaitMs(long maximumWaitMs) {
        this.maximumWaitMs = maximumWaitMs;
    }

    @Override
    public String getSchedule() {
        return this.schedule;
    }

    public void setSchedule(String jobCron) {
        this.schedule = jobCron;
    }

    @Override
    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String jobGroup) {
        this.groupId = jobGroup;
    }

    public AsyncTaskExecutor getParallelTaskExecutor() {
        return this.parallelTaskExecutor;
    }

    public void setParallelTaskExecutor(AsyncTaskExecutor parallelTaskExecutorService) {
        this.parallelTaskExecutor = parallelTaskExecutorService;
    }

    public int getMaximumIterations() {
        return this.maximumIterations;
    }

    public void setMaximumIterations(int maximumIterations) {
        this.maximumIterations = maximumIterations;
    }

    public int getParallelism() {
        return this.parallelism;
    }

    public void setParallelism(int parallelism) {
        if (parallelism < 1) {
            parallelism = 1;
        }
        this.parallelism = parallelism;
    }

    public long getJitter() {
        return this.jitter;
    }

    public void setJitter(long jitter) {
        if (jitter < 0L) {
            jitter = 0L;
        }
        this.jitter = jitter;
    }
}

