/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.central.scheduler;

import java.util.Objects;
import net.solarnetwork.util.ObjectUtils;

public final class JobKey
implements Comparable<JobKey> {
    private final String groupId;
    private final String id;

    public JobKey(String groupId, String id) {
        this.groupId = (String)ObjectUtils.requireNonNullArgument((Object)groupId, (String)"groupId");
        this.id = (String)ObjectUtils.requireNonNullArgument((Object)id, (String)"id");
    }

    public String getDescription() {
        return this.groupId + "." + this.id;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("JobKey{");
        if (this.groupId != null) {
            builder.append("groupId=").append(this.groupId).append(", ");
        }
        if (this.id != null) {
            builder.append("id=").append(this.id);
        }
        builder.append("}");
        return builder.toString();
    }

    @Override
    public int compareTo(JobKey o) {
        int result = this.groupId.compareTo(o.groupId);
        if (result == 0) {
            result = this.id.compareTo(o.id);
        }
        return result;
    }

    public int hashCode() {
        return Objects.hash(this.groupId, this.id);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof JobKey)) {
            return false;
        }
        JobKey other = (JobKey)obj;
        return Objects.equals(this.groupId, other.groupId) && Objects.equals(this.id, other.id);
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getId() {
        return this.id;
    }
}

