/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.central.mail.support;

import jakarta.mail.MessagingException;
import java.util.Arrays;
import java.util.Iterator;
import net.solarnetwork.central.mail.MailAddress;
import net.solarnetwork.central.mail.MailService;
import net.solarnetwork.central.mail.MessageDataSource;
import org.apache.commons.text.WordUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.InputStreamSource;
import org.springframework.core.io.Resource;
import org.springframework.mail.MailMessage;
import org.springframework.mail.MailSender;
import org.springframework.mail.SimpleMailMessage;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMailMessage;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.util.StringUtils;

public class DefaultMailService
implements MailService {
    private final MailSender mailSender;
    private SimpleMailMessage templateMessage;
    private int hardWrapColumnIndex = 0;
    private boolean html = false;
    private final Logger log = LoggerFactory.getLogger(DefaultMailService.class);

    public DefaultMailService(MailSender mailSender) {
        this.mailSender = mailSender;
    }

    private void prepareMailMessage(MailMessage msg, MailAddress address, MessageDataSource messageDataSource) {
        String msgText;
        if (this.templateMessage != null) {
            this.templateMessage.copyTo(msg);
        }
        msg.setTo(address.getTo());
        if (address.getFrom() != null) {
            msg.setFrom(address.getFrom());
        }
        if (address.getCc() != null && address.getCc().length > 0) {
            msg.setCc(address.getCc());
        }
        if (address.getBcc() != null && address.getBcc().length > 0) {
            msg.setBcc(address.getBcc());
        }
        if (messageDataSource.getSubject() != null) {
            msg.setSubject(messageDataSource.getSubject());
        }
        if (!this.html && (msgText = messageDataSource.getBody()) != null) {
            int wrapColumn = this.hardWrapColumnIndex;
            if (wrapColumn > 0) {
                String[] paragraphs;
                StringBuilder buf = new StringBuilder();
                for (String para : paragraphs = msgText.split("\n{2,}")) {
                    if (buf.length() > 0) {
                        buf.append("\n\n");
                    }
                    buf.append(WordUtils.wrap((String)para.replace("\n", " "), (int)wrapColumn));
                }
                msgText = buf.toString();
            }
            msg.setText(msgText);
        }
    }

    @Override
    public void sendMail(MailAddress address, MessageDataSource messageDataSource) {
        Iterator<Resource> attachments;
        Iterator<Resource> iterator = attachments = messageDataSource.getAttachments() != null ? messageDataSource.getAttachments().iterator() : null;
        if (this.html || attachments != null && attachments.hasNext()) {
            if (!(this.mailSender instanceof JavaMailSender)) {
                throw new RuntimeException("Cannot send mail attachments without a JavaMailSender.");
            }
            JavaMailSender sender = (JavaMailSender)this.mailSender;
            try {
                MimeMailMessage msg = new MimeMailMessage(new MimeMessageHelper(sender.createMimeMessage(), 3));
                if (this.html) {
                    msg.getMimeMessageHelper().setText(messageDataSource.getBody(), true);
                }
                this.prepareMailMessage((MailMessage)msg, address, messageDataSource);
                if (attachments != null) {
                    while (attachments.hasNext()) {
                        Resource att = attachments.next();
                        msg.getMimeMessageHelper().addAttachment(att.getFilename(), (InputStreamSource)att);
                    }
                }
                if (this.log.isInfoEnabled()) {
                    this.log.info("Sending MIME mail [{}] from [{}] to [{}]", new Object[]{msg.getMimeMessage().getSubject(), StringUtils.arrayToCommaDelimitedString((Object[])msg.getMimeMessage().getFrom()), StringUtils.arrayToCommaDelimitedString((Object[])msg.getMimeMessage().getAllRecipients())});
                }
                sender.send(msg.getMimeMessage());
            }
            catch (MessagingException e) {
                String err = String.format("Error preparing mail [%s] to %s: %s", messageDataSource.getSubject() != null ? messageDataSource.getSubject() : this.templateMessage.getSubject(), Arrays.toString(address.getTo()), e.getMessage());
                throw new RuntimeException(err, e);
            }
        } else {
            SimpleMailMessage msg = new SimpleMailMessage();
            this.prepareMailMessage((MailMessage)msg, address, messageDataSource);
            if (this.log.isInfoEnabled()) {
                this.log.info("Sending mail [{}] from [{}] to [{}]", new Object[]{msg.getSubject(), msg.getFrom(), StringUtils.arrayToCommaDelimitedString((Object[])msg.getTo())});
            }
            this.mailSender.send(msg);
        }
    }

    public SimpleMailMessage getTemplateMessage() {
        return this.templateMessage;
    }

    public void setTemplateMessage(SimpleMailMessage templateMessage) {
        this.templateMessage = templateMessage;
    }

    public int getHardWrapColumnIndex() {
        return this.hardWrapColumnIndex;
    }

    public void setHardWrapColumnIndex(int hardWrapColumnIndex) {
        this.hardWrapColumnIndex = hardWrapColumnIndex;
    }

    public boolean isHtml() {
        return this.html;
    }

    public void setHtml(boolean html) {
        this.html = html;
    }
}

