/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.central.mail.support;

import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import net.solarnetwork.central.mail.MessageTemplateDataSource;
import net.solarnetwork.central.mail.support.SimpleMessageDataSource;
import net.solarnetwork.util.StringMerger;
import org.apache.commons.text.WordUtils;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.util.StringUtils;

public class ClasspathResourceMessageTemplateDataSource
extends SimpleMessageDataSource
implements MessageTemplateDataSource {
    private final Locale locale;
    private final String resource;
    private final Map<String, ?> model;
    private ClassLoader classLoader;
    private Integer wordWrapCharacterIndex;

    public ClasspathResourceMessageTemplateDataSource(Locale locale, String subject, String resource, Map<String, ?> model) {
        super(subject, null);
        this.locale = locale;
        this.resource = resource;
        this.model = model;
    }

    @Override
    public Locale getLocale() {
        return this.locale;
    }

    @Override
    public Resource getMessageTemplate() {
        Object resourcePath = StringUtils.stripFilenameExtension((String)this.resource) + "_" + this.locale.getLanguage() + "." + StringUtils.getFilenameExtension((String)this.resource);
        ClassLoader loader = this.classLoader;
        if (loader == null) {
            try {
                loader = Thread.currentThread().getContextClassLoader();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (loader == null) {
                loader = this.getClass().getClassLoader();
            }
        }
        if (loader.getResource((String)resourcePath) == null && loader.getResource((String)(resourcePath = this.resource)) == null) {
            throw new RuntimeException("Resource [" + this.resource + "] not available.");
        }
        return new ClassPathResource((String)resourcePath, loader);
    }

    @Override
    public Map<String, ?> getModel() {
        return this.model;
    }

    @Override
    public String getBody() {
        try {
            int wrapColumn;
            String msgText = StringMerger.mergeResource((Resource)this.getMessageTemplate(), this.getModel());
            int n = wrapColumn = this.getWordWrapCharacterIndex() != null ? this.getWordWrapCharacterIndex() : 0;
            if (wrapColumn > 0) {
                String[] paragraphs;
                StringBuilder buf = new StringBuilder();
                for (String para : paragraphs = msgText.split("\n{2,}")) {
                    if (buf.length() > 0) {
                        buf.append("\n\n");
                    }
                    buf.append(WordUtils.wrap((String)para.replace("\n", " "), (int)wrapColumn));
                }
                msgText = buf.toString();
            }
            return msgText;
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to merge resource [" + this.getMessageTemplate().getFilename() + "]", e);
        }
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    @Override
    public Integer getWordWrapCharacterIndex() {
        return this.wordWrapCharacterIndex;
    }

    public void setWordWrapCharacterIndex(Integer wordWrapCharacterIndex) {
        this.wordWrapCharacterIndex = wordWrapCharacterIndex;
    }
}

