/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.central.mail.mock;

import jakarta.mail.BodyPart;
import jakarta.mail.MessagingException;
import jakarta.mail.Session;
import jakarta.mail.internet.MimeMessage;
import jakarta.mail.internet.MimeMultipart;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Properties;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.mail.MailException;
import org.springframework.mail.MailMessage;
import org.springframework.mail.MailParseException;
import org.springframework.mail.MailSender;
import org.springframework.mail.SimpleMailMessage;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMailMessage;
import org.springframework.mail.javamail.MimeMessagePreparator;
import org.springframework.util.FileCopyUtils;

public class MockMailSender
implements MailSender,
JavaMailSender {
    private final Logger log = LoggerFactory.getLogger(MockMailSender.class);
    private final Session session = Session.getInstance((Properties)new Properties());
    private final Queue<MailMessage> sent = new ConcurrentLinkedQueue<MailMessage>();

    public void send(SimpleMailMessage msg) throws MailException {
        if (msg == null) {
            return;
        }
        this.log.info("MOCK: sending mail from {} to {} with text:\n{}\n", new Object[]{msg.getFrom(), msg.getTo(), msg.getText()});
        this.sent.add((MailMessage)msg);
    }

    public void send(SimpleMailMessage ... msgs) throws MailException {
        if (msgs == null) {
            return;
        }
        for (SimpleMailMessage msg : msgs) {
            this.send(msg);
        }
    }

    private Session getSession() {
        return this.session;
    }

    public MimeMessage createMimeMessage() {
        return new MimeMessage(this.getSession());
    }

    public MimeMessage createMimeMessage(InputStream contentStream) throws MailException {
        try {
            return new MimeMessage(this.getSession(), contentStream);
        }
        catch (Exception ex) {
            throw new MailParseException("Could not parse raw MIME content", (Throwable)ex);
        }
    }

    private void extractContent(Object content, StringBuilder buf) throws MessagingException, IOException {
        if (content instanceof String) {
            buf.append(content.toString());
        } else if (content instanceof InputStream) {
            buf.append(FileCopyUtils.copyToString((Reader)new InputStreamReader((InputStream)content, "UTF-8")));
        } else if (content instanceof MimeMultipart) {
            MimeMultipart multi = (MimeMultipart)content;
            for (int i = 0; i < multi.getCount(); ++i) {
                BodyPart part = multi.getBodyPart(i);
                this.extractContent(part, buf);
            }
        } else if (content instanceof BodyPart) {
            BodyPart part = (BodyPart)content;
            this.extractContent(part.getContent(), buf);
        }
    }

    public void send(MimeMessage mimeMessage) throws MailException {
        if (mimeMessage == null) {
            return;
        }
        try {
            StringBuilder buf = new StringBuilder();
            this.extractContent(mimeMessage.getContent(), buf);
            this.log.info("MOCK: sending MIME mail from {} to {} with content:\n{}\n", new Object[]{mimeMessage.getFrom(), mimeMessage.getAllRecipients(), buf.toString()});
        }
        catch (MessagingException | IOException throwable) {
            // empty catch block
        }
        this.sent.add((MailMessage)new MimeMailMessage(mimeMessage));
    }

    public void send(MimeMessage ... mimeMessages) throws MailException {
        if (mimeMessages == null) {
            return;
        }
        for (MimeMessage msg : mimeMessages) {
            this.send(msg);
        }
    }

    public void send(MimeMessagePreparator mimeMessagePreparator) throws MailException {
        if (mimeMessagePreparator == null) {
            return;
        }
        MimeMessage mimeMessage = this.createMimeMessage();
        try {
            mimeMessagePreparator.prepare(mimeMessage);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.send(mimeMessage);
    }

    public void send(MimeMessagePreparator ... mimeMessagePreparators) throws MailException {
        if (mimeMessagePreparators == null) {
            return;
        }
        for (MimeMessagePreparator mimeMessagePreparator : mimeMessagePreparators) {
            this.send(mimeMessagePreparator);
        }
    }

    public Logger getLog() {
        return this.log;
    }

    public Queue<MailMessage> getSent() {
        return this.sent;
    }
}

