/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.central.domain;

import com.fasterxml.uuid.UUIDComparator;
import java.io.Serializable;
import java.util.Objects;
import java.util.UUID;
import net.solarnetwork.central.domain.BasePK;
import net.solarnetwork.central.domain.CompositeKey;
import net.solarnetwork.central.domain.CompositeKey2;
import net.solarnetwork.central.domain.UserIdRelated;
import net.solarnetwork.util.ObjectUtils;

public final class UserUuidPK
extends BasePK
implements Serializable,
Cloneable,
Comparable<UserUuidPK>,
CompositeKey2<Long, UUID>,
UserIdRelated {
    private static final long serialVersionUID = 417842772182618447L;
    public static final Long UNASSIGNED_USER_ID = Long.MIN_VALUE;
    public static final UUID UNASSIGNED_UUID_ID = UUID.fromString("00000000-0000-7000-b000-000000000000");
    private final Long userId;
    private final UUID uuid;

    public static UserUuidPK unassignedUuidKey(Long userId) {
        return new UserUuidPK(userId, UNASSIGNED_UUID_ID);
    }

    public UserUuidPK(Long userId, UUID uuid) {
        this.userId = (Long)ObjectUtils.requireNonNullArgument((Object)userId, (String)"userId");
        this.uuid = (UUID)ObjectUtils.requireNonNullArgument((Object)uuid, (String)"uuid");
    }

    @Override
    public int compareTo(UserUuidPK o) {
        if (o == null) {
            return 1;
        }
        int comparison = this.userId.compareTo(o.userId);
        if (comparison != 0) {
            return comparison;
        }
        return UUIDComparator.staticCompare((UUID)this.uuid, (UUID)o.uuid);
    }

    @Override
    protected void populateIdValue(StringBuilder buf) {
        buf.append("u=").append(this.userId);
        buf.append(";i=").append(this.uuid);
    }

    @Override
    protected void populateStringValue(StringBuilder buf) {
        buf.append("userId=").append(this.userId);
        buf.append(", uuid=").append(this.uuid);
    }

    @Override
    protected UserUuidPK clone() {
        return (UserUuidPK)super.clone();
    }

    public int hashCode() {
        return Objects.hash(this.userId, this.uuid);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof UserUuidPK)) {
            return false;
        }
        UserUuidPK other = (UserUuidPK)obj;
        return Objects.equals(this.userId, other.userId) && Objects.equals(this.uuid, other.uuid);
    }

    @Override
    public final Long getUserId() {
        return this.userId;
    }

    public final UUID getUuid() {
        return this.uuid;
    }

    @Override
    public final Long keyComponent1() {
        return this.getUserId();
    }

    @Override
    public final UUID keyComponent2() {
        return this.getUuid();
    }

    @Override
    public final boolean keyComponentIsAssigned(int index) {
        if (index == 0) {
            return this.userId != UNASSIGNED_USER_ID;
        }
        if (index == 1) {
            return this.uuid != UNASSIGNED_UUID_ID;
        }
        return CompositeKey2.super.keyComponentIsAssigned(index);
    }

    public final boolean userIdIsAssigned() {
        return this.keyComponentIsAssigned(0);
    }

    public final boolean uuidIsAssigned() {
        return this.keyComponentIsAssigned(1);
    }

    @Override
    public <T> T keyComponentValue(int index, Object val) {
        try {
            if (index == 0) {
                if (val == null) {
                    return (T)UNASSIGNED_USER_ID;
                }
                if (val instanceof Long) {
                    Long n = (Long)val;
                    return (T)n;
                }
                if (val instanceof Number) {
                    Number n = (Number)val;
                    return (T)Long.valueOf(n.longValue());
                }
                return (T)Long.valueOf(val.toString());
            }
            if (index == 1) {
                if (val == null) {
                    return (T)UNASSIGNED_UUID_ID;
                }
                if (val instanceof UUID) {
                    UUID u = (UUID)val;
                    return (T)u;
                }
                return (T)UUID.fromString(val.toString());
            }
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Key component %d does not support value %s.".formatted(index, val));
        }
        throw new IllegalArgumentException("Key component %d out of range.".formatted(index));
    }

    @Override
    public UserUuidPK createKey(CompositeKey template, Object ... components) {
        Object v1;
        Object object = components != null && components.length > 0 ? components[0] : (v1 = template != null ? template.keyComponent(0) : null);
        Object v2 = components != null && components.length > 1 ? components[1] : (template != null ? template.keyComponent(1) : null);
        Long k1 = v1 != null ? (Long)this.keyComponentValue(0, v1) : UNASSIGNED_USER_ID;
        UUID k2 = v2 != null ? (UUID)this.keyComponentValue(1, v2) : UNASSIGNED_UUID_ID;
        return new UserUuidPK(k1, k2);
    }
}

