/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.central.domain;

import java.io.Serializable;
import java.util.Objects;
import java.util.UUID;
import net.solarnetwork.central.domain.BasePK;
import net.solarnetwork.central.domain.CompositeKey;
import net.solarnetwork.central.domain.CompositeKey3;
import net.solarnetwork.central.domain.UserIdRelated;
import net.solarnetwork.central.domain.UserLongCompositePK;
import net.solarnetwork.util.ObjectUtils;

public class UserUuidLongCompositePK
extends BasePK
implements Serializable,
Cloneable,
Comparable<UserUuidLongCompositePK>,
CompositeKey3<Long, UUID, Long>,
UserIdRelated {
    private static final long serialVersionUID = 5569471640101762323L;
    public static final Long UNASSIGNED_USER_ID = Long.MIN_VALUE;
    public static final UUID UNASSIGNED_GROUP_ID = new UUID(0L, 0L);
    public static final Long UNASSIGNED_ENTITY_ID = Long.MIN_VALUE;
    private final Long userId;
    private final UUID groupId;
    private final Long entityId;

    public static UserUuidLongCompositePK unassignedEntityIdKey(Long userId) {
        return new UserUuidLongCompositePK(userId, UNASSIGNED_GROUP_ID, UNASSIGNED_ENTITY_ID);
    }

    public static UserUuidLongCompositePK unassignedEntityIdKey(Long userId, UUID groupId) {
        return new UserUuidLongCompositePK(userId, groupId, UNASSIGNED_ENTITY_ID);
    }

    public UserUuidLongCompositePK(Long userId, UUID groupId, Long entityId) {
        this.userId = (Long)ObjectUtils.requireNonNullArgument((Object)userId, (String)"userId");
        this.groupId = (UUID)ObjectUtils.requireNonNullArgument((Object)groupId, (String)"groupId");
        this.entityId = (Long)ObjectUtils.requireNonNullArgument((Object)entityId, (String)"entityId");
    }

    @Override
    public int compareTo(UserUuidLongCompositePK o) {
        if (o == null) {
            return 1;
        }
        int comparison = this.userId.compareTo(o.userId);
        if (comparison != 0) {
            return comparison;
        }
        comparison = this.groupId.compareTo(o.groupId);
        if (comparison != 0) {
            return comparison;
        }
        return this.entityId.compareTo(o.entityId);
    }

    @Override
    protected void populateIdValue(StringBuilder buf) {
        buf.append("u=").append(this.userId);
        buf.append(";g=").append(this.groupId);
        buf.append(";i=").append(this.entityId);
    }

    @Override
    protected void populateStringValue(StringBuilder buf) {
        buf.append("userId=").append(this.userId);
        buf.append(", groupId=").append(this.groupId);
        buf.append(", entityId=").append(this.entityId);
    }

    @Override
    protected UserLongCompositePK clone() {
        return (UserLongCompositePK)super.clone();
    }

    public int hashCode() {
        return Objects.hash(this.userId, this.groupId, this.entityId);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof UserUuidLongCompositePK)) {
            return false;
        }
        UserUuidLongCompositePK other = (UserUuidLongCompositePK)obj;
        return Objects.equals(this.userId, other.userId) && Objects.equals(this.groupId, other.groupId) && Objects.equals(this.entityId, other.entityId);
    }

    public String ident() {
        return String.format("(%d,%s,%d)", this.userId, this.groupId, this.entityId);
    }

    @Override
    public final Long getUserId() {
        return this.userId;
    }

    public final UUID getGroupId() {
        return this.groupId;
    }

    public final Long getEntityId() {
        return this.entityId;
    }

    @Override
    public final Long keyComponent1() {
        return this.getUserId();
    }

    @Override
    public final UUID keyComponent2() {
        return this.getGroupId();
    }

    @Override
    public final Long keyComponent3() {
        return this.getEntityId();
    }

    @Override
    public final boolean keyComponentIsAssigned(int index) {
        if (index == 0) {
            return this.userId != UNASSIGNED_USER_ID;
        }
        if (index == 1) {
            return this.groupId != UNASSIGNED_GROUP_ID;
        }
        if (index == 2) {
            return this.entityId != UNASSIGNED_ENTITY_ID;
        }
        return CompositeKey3.super.keyComponentIsAssigned(index);
    }

    public final boolean userIdIsAssigned() {
        return this.keyComponentIsAssigned(0);
    }

    public final boolean groupIdIsAssigned() {
        return this.keyComponentIsAssigned(1);
    }

    public final boolean entityIdIsAssigned() {
        return this.keyComponentIsAssigned(2);
    }

    @Override
    public <T> T keyComponentValue(int index, Object val) {
        try {
            if (index == 0 || index == 2) {
                if (val == null) {
                    return (T)UNASSIGNED_USER_ID;
                }
                if (val instanceof Long) {
                    Long n = (Long)val;
                    return (T)n;
                }
                if (val instanceof Number) {
                    Number n = (Number)val;
                    return (T)Long.valueOf(n.longValue());
                }
                return (T)Long.valueOf(val.toString());
            }
            if (index == 1) {
                if (val == null) {
                    return (T)UNASSIGNED_GROUP_ID;
                }
                if (val instanceof UUID) {
                    UUID u = (UUID)val;
                    return (T)u;
                }
                return (T)UUID.fromString(val.toString());
            }
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Key component %d does not support value %s.".formatted(index, val));
        }
        throw new IllegalArgumentException("Key component %d out of range.".formatted(index));
    }

    @Override
    public UserUuidLongCompositePK createKey(CompositeKey template, Object ... components) {
        Object v2;
        Object v1;
        Object object = components != null && components.length > 0 ? components[0] : (v1 = template != null ? template.keyComponent(0) : null);
        Object object2 = components != null && components.length > 1 ? components[1] : (v2 = template != null ? template.keyComponent(1) : null);
        Object v3 = components != null && components.length > 2 ? components[2] : (template != null ? template.keyComponent(2) : null);
        Long k1 = v1 != null ? (Long)this.keyComponentValue(0, v1) : UNASSIGNED_USER_ID;
        UUID k2 = v2 != null ? (UUID)this.keyComponentValue(1, v2) : UNASSIGNED_GROUP_ID;
        Long k3 = v3 != null ? (Long)this.keyComponentValue(2, v3) : UNASSIGNED_ENTITY_ID;
        return new UserUuidLongCompositePK(k1, k2, k3);
    }
}

