/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.central.domain;

import java.io.Serializable;
import java.util.Objects;
import net.solarnetwork.central.domain.BasePK;
import net.solarnetwork.central.domain.CompositeKey;
import net.solarnetwork.central.domain.CompositeKey3;
import net.solarnetwork.central.domain.UserIdRelated;
import net.solarnetwork.central.domain.UserLongCompositePK;
import net.solarnetwork.util.ObjectUtils;

public final class UserLongIntegerCompositePK
extends BasePK
implements Serializable,
Cloneable,
Comparable<UserLongIntegerCompositePK>,
CompositeKey3<Long, Long, Integer>,
UserIdRelated {
    private static final long serialVersionUID = -2993287060057007236L;
    public static final Long UNASSIGNED_USER_ID = Long.MIN_VALUE;
    public static final Long UNASSIGNED_GROUP_ID = Long.MIN_VALUE;
    public static final Integer UNASSIGNED_ENTITY_ID = Integer.MIN_VALUE;
    private final Long userId;
    private final Long groupId;
    private final Integer entityId;

    public static UserLongIntegerCompositePK unassignedEntityIdKey(Long userId, Long groupId) {
        return new UserLongIntegerCompositePK(userId, groupId, UNASSIGNED_ENTITY_ID);
    }

    public UserLongIntegerCompositePK(Long userId, Long groupId, Integer entityId) {
        this.userId = (Long)ObjectUtils.requireNonNullArgument((Object)userId, (String)"userId");
        this.groupId = (Long)ObjectUtils.requireNonNullArgument((Object)groupId, (String)"groupId");
        this.entityId = (Integer)ObjectUtils.requireNonNullArgument((Object)entityId, (String)"entityId");
    }

    @Override
    public int compareTo(UserLongIntegerCompositePK o) {
        if (o == null) {
            return 1;
        }
        int comparison = this.userId.compareTo(o.userId);
        if (comparison != 0) {
            return comparison;
        }
        comparison = this.groupId.compareTo(o.groupId);
        if (comparison != 0) {
            return comparison;
        }
        return this.entityId.compareTo(o.entityId);
    }

    @Override
    protected void populateIdValue(StringBuilder buf) {
        buf.append("u=").append(this.userId);
        buf.append(";g=").append(this.groupId);
        buf.append(";i=").append(this.entityId);
    }

    @Override
    protected void populateStringValue(StringBuilder buf) {
        buf.append("userId=").append(this.userId);
        buf.append(", groupId=").append(this.groupId);
        buf.append(", entityId=").append(this.entityId);
    }

    @Override
    protected UserLongCompositePK clone() {
        return (UserLongCompositePK)super.clone();
    }

    public int hashCode() {
        return Objects.hash(this.userId, this.groupId, this.entityId);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof UserLongIntegerCompositePK)) {
            return false;
        }
        UserLongIntegerCompositePK other = (UserLongIntegerCompositePK)obj;
        return Objects.equals(this.userId, other.userId) && Objects.equals(this.groupId, other.groupId) && Objects.equals(this.entityId, other.entityId);
    }

    public String ident() {
        return String.format("(%d,%d,%d)", this.userId, this.groupId, this.entityId);
    }

    @Override
    public final Long getUserId() {
        return this.userId;
    }

    public final Long getGroupId() {
        return this.groupId;
    }

    public final Integer getEntityId() {
        return this.entityId;
    }

    @Override
    public final Long keyComponent1() {
        return this.getUserId();
    }

    @Override
    public final Long keyComponent2() {
        return this.getGroupId();
    }

    @Override
    public final Integer keyComponent3() {
        return this.getEntityId();
    }

    @Override
    public final boolean keyComponentIsAssigned(int index) {
        if (index == 0) {
            return this.userId != UNASSIGNED_USER_ID;
        }
        if (index == 1) {
            return this.groupId != UNASSIGNED_GROUP_ID;
        }
        if (index == 2) {
            return this.entityId != UNASSIGNED_ENTITY_ID;
        }
        return CompositeKey3.super.keyComponentIsAssigned(index);
    }

    public final boolean userIdIsAssigned() {
        return this.keyComponentIsAssigned(0);
    }

    public final boolean groupIdIsAssigned() {
        return this.keyComponentIsAssigned(1);
    }

    public final boolean entityIdIsAssigned() {
        return this.keyComponentIsAssigned(2);
    }

    @Override
    public <T> T keyComponentValue(int index, Object val) {
        try {
            if (index == 0 || index == 1) {
                if (val == null) {
                    return (T)UNASSIGNED_GROUP_ID;
                }
                if (val instanceof Long) {
                    Long n = (Long)val;
                    return (T)n;
                }
                if (val instanceof Number) {
                    Number n = (Number)val;
                    return (T)Long.valueOf(n.longValue());
                }
                return (T)Long.valueOf(val.toString());
            }
            if (index == 2) {
                if (val == null) {
                    return (T)UNASSIGNED_ENTITY_ID;
                }
                if (val instanceof Integer) {
                    Integer n = (Integer)val;
                    return (T)n;
                }
                if (val instanceof Number) {
                    Number n = (Number)val;
                    return (T)Integer.valueOf(n.intValue());
                }
                return (T)Integer.valueOf(val.toString());
            }
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Key component %d does not support value %s.".formatted(index, val));
        }
        throw new IllegalArgumentException("Key component %d out of range.".formatted(index));
    }

    @Override
    public UserLongIntegerCompositePK createKey(CompositeKey template, Object ... components) {
        Object v2;
        Object v1;
        Object object = components != null && components.length > 0 ? components[0] : (v1 = template != null ? template.keyComponent(0) : null);
        Object object2 = components != null && components.length > 1 ? components[1] : (v2 = template != null ? template.keyComponent(1) : null);
        Object v3 = components != null && components.length > 2 ? components[2] : (template != null ? template.keyComponent(2) : null);
        Long k1 = v1 != null ? (Long)this.keyComponentValue(0, v1) : UNASSIGNED_USER_ID;
        Long k2 = v2 != null ? (Long)this.keyComponentValue(1, v2) : UNASSIGNED_GROUP_ID;
        Integer k3 = v3 != null ? (Integer)this.keyComponentValue(2, v3) : UNASSIGNED_ENTITY_ID;
        return new UserLongIntegerCompositePK(k1, k2, k3);
    }
}

