/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.central.domain;

import java.io.Serializable;
import java.util.Objects;
import net.solarnetwork.central.domain.BasePK;
import net.solarnetwork.central.domain.CompositeKey;
import net.solarnetwork.central.domain.CompositeKey2;
import net.solarnetwork.central.domain.UserIdRelated;
import net.solarnetwork.util.ObjectUtils;

public final class UserLongCompositePK
extends BasePK
implements Serializable,
Cloneable,
Comparable<UserLongCompositePK>,
CompositeKey2<Long, Long>,
UserIdRelated {
    private static final long serialVersionUID = 2537083574768869025L;
    public static final Long UNASSIGNED_USER_ID = Long.MIN_VALUE;
    public static final Long UNASSIGNED_ENTITY_ID = Long.MIN_VALUE;
    private final Long userId;
    private final Long entityId;

    public static UserLongCompositePK unassignedEntityIdKey(Long userId) {
        return new UserLongCompositePK(userId, UNASSIGNED_ENTITY_ID);
    }

    public UserLongCompositePK(Long userId, Long entityId) {
        this.userId = (Long)ObjectUtils.requireNonNullArgument((Object)userId, (String)"userId");
        this.entityId = (Long)ObjectUtils.requireNonNullArgument((Object)entityId, (String)"entityId");
    }

    @Override
    public int compareTo(UserLongCompositePK o) {
        if (o == null) {
            return 1;
        }
        int comparison = this.userId.compareTo(o.userId);
        if (comparison != 0) {
            return comparison;
        }
        return this.entityId.compareTo(o.entityId);
    }

    @Override
    protected void populateIdValue(StringBuilder buf) {
        buf.append("u=").append(this.userId);
        buf.append(";i=").append(this.entityId);
    }

    @Override
    protected void populateStringValue(StringBuilder buf) {
        buf.append("userId=").append(this.userId);
        buf.append(", entityId=").append(this.entityId);
    }

    @Override
    protected UserLongCompositePK clone() {
        return (UserLongCompositePK)super.clone();
    }

    public int hashCode() {
        return Objects.hash(this.userId, this.entityId);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof UserLongCompositePK)) {
            return false;
        }
        UserLongCompositePK other = (UserLongCompositePK)obj;
        return Objects.equals(this.userId, other.userId) && Objects.equals(this.entityId, other.entityId);
    }

    public String ident() {
        return String.format("(%d,%d)", this.userId, this.entityId);
    }

    @Override
    public final Long getUserId() {
        return this.userId;
    }

    public final Long getEntityId() {
        return this.entityId;
    }

    @Override
    public final Long keyComponent1() {
        return this.getUserId();
    }

    @Override
    public final Long keyComponent2() {
        return this.getEntityId();
    }

    @Override
    public final boolean keyComponentIsAssigned(int index) {
        if (index == 0) {
            return this.userId != UNASSIGNED_USER_ID;
        }
        if (index == 1) {
            return this.entityId != UNASSIGNED_ENTITY_ID;
        }
        return CompositeKey2.super.keyComponentIsAssigned(index);
    }

    public final boolean userIdIsAssigned() {
        return this.keyComponentIsAssigned(0);
    }

    public final boolean entityIdIsAssigned() {
        return this.keyComponentIsAssigned(1);
    }

    @Override
    public <T> T keyComponentValue(int index, Object val) {
        try {
            if (index == 0 || index == 1) {
                if (val == null) {
                    return (T)UNASSIGNED_ENTITY_ID;
                }
                if (val instanceof Long) {
                    Long n = (Long)val;
                    return (T)n;
                }
                if (val instanceof Number) {
                    Number n = (Number)val;
                    return (T)Long.valueOf(n.longValue());
                }
                return (T)Long.valueOf(val.toString());
            }
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Key component %d does not support value %s.".formatted(index, val));
        }
        throw new IllegalArgumentException("Key component %d out of range.".formatted(index));
    }

    @Override
    public UserLongCompositePK createKey(CompositeKey template, Object ... components) {
        Object v1;
        Object object = components != null && components.length > 0 ? components[0] : (v1 = template != null ? template.keyComponent(0) : null);
        Object v2 = components != null && components.length > 1 ? components[1] : (template != null ? template.keyComponent(1) : null);
        Long k1 = v1 != null ? (Long)this.keyComponentValue(0, v1) : UNASSIGNED_USER_ID;
        Long k2 = v2 != null ? (Long)this.keyComponentValue(1, v2) : UNASSIGNED_ENTITY_ID;
        return new UserLongCompositePK(k1, k2);
    }
}

