/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.central.domain;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.solarnetwork.central.dao.BasicUserMetadataFilter;
import net.solarnetwork.central.domain.UserFilter;
import net.solarnetwork.central.domain.UserMetadataFilter;
import net.solarnetwork.central.support.FilterSupport;
import net.solarnetwork.codec.JsonUtils;
import net.solarnetwork.domain.MutableSortDescriptor;
import net.solarnetwork.domain.SortDescriptor;

public class UserFilterCommand
extends FilterSupport
implements UserFilter {
    private static final long serialVersionUID = 915646548230356302L;
    private List<MutableSortDescriptor> sorts;
    private Integer offset = 0;
    private Integer max;
    private String email;
    private Map<String, Object> internalData;

    public UserMetadataFilter toUserMetadataFilter() {
        BasicUserMetadataFilter f = new BasicUserMetadataFilter();
        f.setUserIds(this.getUserIds());
        f.setTags(this.getTags());
        if (this.sorts != null) {
            f.setSorts(this.getSortDescriptors());
        }
        f.setMax(this.max);
        f.setOffset(this.offset);
        return f;
    }

    public List<MutableSortDescriptor> getSorts() {
        return this.sorts;
    }

    public void setSorts(List<MutableSortDescriptor> sorts) {
        this.sorts = sorts;
    }

    public List<SortDescriptor> getSortDescriptors() {
        if (this.sorts == null) {
            return Collections.emptyList();
        }
        return new ArrayList<MutableSortDescriptor>(this.sorts);
    }

    public Integer getOffset() {
        return this.offset;
    }

    public void setOffset(Integer offset) {
        this.offset = offset;
    }

    public Integer getMax() {
        return this.max;
    }

    public void setMax(Integer max) {
        this.max = max;
    }

    @Override
    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    @Override
    public Map<String, Object> getInternalData() {
        return this.internalData;
    }

    public void setInternalData(Map<String, Object> internalData) {
        this.internalData = internalData;
    }

    public String getInternalDataJson() {
        return JsonUtils.getJSONString(this.internalData, null);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.internalData == null ? 0 : this.internalData.hashCode());
        result = 31 * result + (this.email == null ? 0 : this.email.hashCode());
        result = 31 * result + (this.max == null ? 0 : this.max.hashCode());
        result = 31 * result + (this.offset == null ? 0 : this.offset.hashCode());
        result = 31 * result + (this.sorts == null ? 0 : this.sorts.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof UserFilterCommand)) {
            return false;
        }
        UserFilterCommand other = (UserFilterCommand)obj;
        if (this.internalData == null ? other.internalData != null : !this.internalData.equals(other.internalData)) {
            return false;
        }
        if (this.email == null ? other.email != null : !this.email.equals(other.email)) {
            return false;
        }
        if (this.max == null ? other.max != null : !this.max.equals(other.max)) {
            return false;
        }
        if (this.offset == null ? other.offset != null : !this.offset.equals(other.offset)) {
            return false;
        }
        return !(this.sorts == null ? other.sorts != null : !this.sorts.equals(other.sorts));
    }
}

