/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.central.domain;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.UUID;
import net.solarnetwork.central.dao.UserRelatedEntity;
import net.solarnetwork.central.domain.UserUuidPK;
import net.solarnetwork.dao.BasicIdentity;
import net.solarnetwork.dao.Entity;
import net.solarnetwork.util.ObjectUtils;
import net.solarnetwork.util.UuidUtils;

public class UserEvent
extends BasicIdentity<UserUuidPK>
implements Entity<UserUuidPK>,
UserRelatedEntity<UserUuidPK>,
Serializable,
Cloneable {
    private static final long serialVersionUID = -2418940464038903514L;
    private final String[] tags;
    private final String message;
    private final String data;

    public UserEvent(UserUuidPK id, String[] tags, String message, String data) {
        super((Comparable)((UserUuidPK)ObjectUtils.requireNonNullArgument((Object)id, (String)"id")));
        this.tags = (String[])ObjectUtils.requireNonEmptyArgument((Object[])tags, (String)"tags");
        this.message = message;
        this.data = data;
    }

    public UserEvent(Long userId, UUID eventId, String[] tags, String message, String data) {
        this(new UserUuidPK(userId, eventId), tags, message, data);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("UserEvent{");
        builder.append("userId=");
        builder.append(this.getUserId());
        builder.append(", ");
        builder.append("eventId=");
        builder.append(this.getEventId());
        builder.append(", ");
        if (this.tags != null) {
            builder.append("tags=");
            builder.append(Arrays.toString(this.tags));
            builder.append(", ");
        }
        if (this.message != null) {
            builder.append("message=");
            builder.append(this.message);
            builder.append(", ");
        }
        if (this.data != null) {
            builder.append("data=");
            builder.append(this.data);
        }
        builder.append("}");
        return builder.toString();
    }

    public UserEvent clone() {
        return (UserEvent)super.clone();
    }

    @Override
    public Long getUserId() {
        return ((UserUuidPK)this.getId()).getUserId();
    }

    public Instant getCreated() {
        return UuidUtils.extractTimestamp((UUID)this.getEventId(), (int)-10);
    }

    public UUID getEventId() {
        return ((UserUuidPK)this.getId()).getUuid();
    }

    public String[] getTags() {
        return this.tags;
    }

    public String getMessage() {
        return this.message;
    }

    public String getData() {
        return this.data;
    }
}

