/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.central.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.time.Instant;
import java.util.TimeZone;
import net.solarnetwork.central.dao.BaseEntity;
import net.solarnetwork.central.domain.NodeIdentity;
import net.solarnetwork.central.domain.SolarLocation;
import net.solarnetwork.domain.SerializeIgnore;

public class SolarNode
extends BaseEntity
implements Cloneable,
Serializable,
NodeIdentity {
    private static final long serialVersionUID = 531103294940393083L;
    private String name = null;
    private Long locationId = null;
    @SerializeIgnore
    @JsonIgnore
    private SolarLocation location;

    public SolarNode() {
    }

    public SolarNode(Long id, Long locationId) {
        this.setId(id);
        this.setCreated(Instant.now());
        this.setLocationId(locationId);
    }

    public String toString() {
        return "SolarNode{id=" + this.getId() + ",locationId=" + this.locationId + "}";
    }

    public TimeZone getTimeZone() {
        return this.location != null && this.location.getTimeZoneId() != null ? TimeZone.getTimeZone(this.location.getTimeZoneId()) : null;
    }

    public Long getLocationId() {
        return this.locationId;
    }

    public void setLocationId(Long locationId) {
        this.locationId = locationId;
    }

    @JsonIgnore
    public SolarLocation getLocation() {
        return this.location;
    }

    public void setLocation(SolarLocation location) {
        this.location = location;
        if (location != null && location.getId() != null) {
            this.locationId = location.getId();
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }
}

