/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.central.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TimeZone;
import net.solarnetwork.central.dao.BaseEntity;
import net.solarnetwork.central.domain.Location;
import net.solarnetwork.central.domain.LocationMatch;
import net.solarnetwork.domain.SerializeIgnore;
import org.springframework.util.StringUtils;

public class SolarLocation
extends BaseEntity
implements Cloneable,
Serializable,
Location,
LocationMatch {
    private static final long serialVersionUID = -3752573628286835489L;
    private String name;
    private String country;
    private String region;
    private String stateOrProvince;
    private String locality;
    private String postalCode;
    private String street;
    private BigDecimal latitude;
    private BigDecimal longitude;
    private BigDecimal elevation;
    private String timeZoneId;

    public SolarLocation() {
    }

    public SolarLocation(Location loc) {
        this.setName(loc.getName());
        this.setCountry(loc.getCountry());
        this.setRegion(loc.getRegion());
        this.setStateOrProvince(loc.getStateOrProvince());
        this.setLocality(loc.getLocality());
        this.setPostalCode(loc.getPostalCode());
        this.setStreet(loc.getStreet());
        this.setLatitude(loc.getLatitude());
        this.setLongitude(loc.getLongitude());
        this.setElevation(loc.getElevation());
        this.setTimeZoneId(loc.getTimeZoneId());
    }

    public void removeEmptyValues() {
        if (!StringUtils.hasText((String)this.country)) {
            this.country = null;
        }
        if (!StringUtils.hasText((String)this.locality)) {
            this.locality = null;
        }
        if (!StringUtils.hasText((String)this.name)) {
            this.name = null;
        }
        if (!StringUtils.hasText((String)this.postalCode)) {
            this.postalCode = null;
        }
        if (!StringUtils.hasText((String)this.region)) {
            this.region = null;
        }
        if (!StringUtils.hasText((String)this.stateOrProvince)) {
            this.stateOrProvince = null;
        }
        if (!StringUtils.hasText((String)this.street)) {
            this.street = null;
        }
        if (!StringUtils.hasText((String)this.timeZoneId)) {
            this.timeZoneId = null;
        }
    }

    public static SolarLocation normalizedLocation(Location loc) {
        String street;
        String postalCode;
        String locality;
        String state;
        String region;
        TimeZone tz;
        String name;
        assert (loc != null);
        SolarLocation norm = new SolarLocation();
        if (loc.getName() != null && (name = loc.getName().trim()).length() > 0) {
            norm.setName(name);
        }
        if (loc.getCountry() != null && loc.getCountry().length() >= 2) {
            String country = loc.getCountry();
            if (country.length() > 2) {
                country = country.substring(0, 2);
            }
            norm.setCountry(country.toUpperCase());
        }
        if (loc.getTimeZoneId() != null && (tz = TimeZone.getTimeZone(loc.getTimeZoneId())) != null) {
            norm.setTimeZoneId(tz.getID());
        }
        if (loc.getRegion() != null && (region = loc.getRegion().trim()).length() > 0) {
            norm.setRegion(region);
        }
        if (loc.getStateOrProvince() != null && (state = loc.getStateOrProvince().trim()).length() > 0) {
            norm.setStateOrProvince(state);
        }
        if (loc.getLocality() != null && (locality = loc.getLocality().trim()).length() > 0) {
            norm.setLocality(locality);
        }
        if (loc.getPostalCode() != null && (postalCode = loc.getPostalCode().trim().toUpperCase()).length() > 0) {
            norm.setPostalCode(postalCode);
        }
        if (loc.getStreet() != null && (street = loc.getStreet().trim()).length() > 0) {
            norm.setStreet(street);
        }
        norm.setLatitude(loc.getLatitude());
        norm.setLongitude(loc.getLongitude());
        norm.setElevation(loc.getElevation());
        return norm;
    }

    @Override
    @SerializeIgnore
    @JsonIgnore
    public Map<String, ?> getFilter() {
        LinkedHashMap<String, Object> filter = new LinkedHashMap<String, Object>();
        if (this.name != null) {
            filter.put("name", this.name);
        }
        if (this.country != null) {
            filter.put("c", this.country);
        }
        if (this.region != null) {
            filter.put("region", this.region);
        }
        if (this.stateOrProvince != null) {
            filter.put("st", this.stateOrProvince);
        }
        if (this.postalCode != null) {
            filter.put("postalCode", this.postalCode);
        }
        if (this.locality != null) {
            filter.put("l", this.locality);
        }
        if (this.street != null) {
            filter.put("street", this.street);
        }
        if (this.latitude != null) {
            filter.put("latitude", this.latitude);
        }
        if (this.longitude != null) {
            filter.put("longitude", this.longitude);
        }
        if (this.elevation != null) {
            filter.put("elevation", this.elevation);
        }
        if (this.timeZoneId != null) {
            filter.put("tz", this.timeZoneId);
        }
        return filter;
    }

    public String toString() {
        return "SolarLocation{id=" + String.valueOf(this.getId() == null ? "" : this.getId()) + ",name=" + (this.name == null ? "" : this.name) + "}";
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getCountry() {
        return this.country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    @Override
    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    @Override
    public String getStateOrProvince() {
        return this.stateOrProvince;
    }

    public void setStateOrProvince(String stateOrProvince) {
        this.stateOrProvince = stateOrProvince;
    }

    @Override
    public String getLocality() {
        return this.locality;
    }

    public void setLocality(String locality) {
        this.locality = locality;
    }

    @Override
    public String getPostalCode() {
        return this.postalCode;
    }

    public void setPostalCode(String postalCode) {
        this.postalCode = postalCode;
    }

    @Override
    public String getStreet() {
        return this.street;
    }

    public void setStreet(String street) {
        this.street = street;
    }

    @Override
    public BigDecimal getLatitude() {
        return this.latitude;
    }

    public void setLatitude(BigDecimal latitude) {
        this.latitude = latitude;
    }

    public void setLat(BigDecimal latitude) {
        this.setLatitude(latitude);
    }

    @Override
    public BigDecimal getLongitude() {
        return this.longitude;
    }

    public void setLongitude(BigDecimal longitude) {
        this.longitude = longitude;
    }

    public void setLon(BigDecimal longitude) {
        this.setLongitude(longitude);
    }

    public String getTimeZoneId() {
        return this.timeZoneId;
    }

    public void setTimeZoneId(String timeZoneId) {
        this.timeZoneId = timeZoneId;
    }

    public void setZone(String timeZoneId) {
        this.setTimeZoneId(timeZoneId);
    }

    @Override
    public BigDecimal getElevation() {
        return this.elevation;
    }

    public void setElevation(BigDecimal elevation) {
        this.elevation = elevation;
    }

    public void setEl(BigDecimal elevation) {
        this.setElevation(elevation);
    }
}

