/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.central.domain;

import java.io.Serializable;
import java.util.Objects;
import net.solarnetwork.central.domain.BasePK;
import net.solarnetwork.central.domain.CompositeKey;
import net.solarnetwork.central.domain.CompositeKey2;
import net.solarnetwork.central.domain.UserLongCompositePK;
import net.solarnetwork.util.ObjectUtils;

public final class LongIntegerCompositePK
extends BasePK
implements Serializable,
Cloneable,
Comparable<LongIntegerCompositePK>,
CompositeKey2<Long, Integer> {
    private static final long serialVersionUID = 8423043492448548574L;
    public static final Long UNASSIGNED_GROUP_ID = Long.MIN_VALUE;
    public static final Integer UNASSIGNED_ENTITY_ID = Integer.MIN_VALUE;
    private final Long groupId;
    private final Integer entityId;

    public static LongIntegerCompositePK unassignedEntityIdKey(Long groupId) {
        return new LongIntegerCompositePK(groupId, UNASSIGNED_ENTITY_ID);
    }

    public LongIntegerCompositePK(Long groupId, Integer entityId) {
        this.groupId = (Long)ObjectUtils.requireNonNullArgument((Object)groupId, (String)"groupId");
        this.entityId = (Integer)ObjectUtils.requireNonNullArgument((Object)entityId, (String)"entityId");
    }

    @Override
    public int compareTo(LongIntegerCompositePK o) {
        if (o == null) {
            return 1;
        }
        int comparison = this.groupId.compareTo(o.groupId);
        if (comparison != 0) {
            return comparison;
        }
        return this.entityId.compareTo(o.entityId);
    }

    @Override
    protected void populateIdValue(StringBuilder buf) {
        buf.append("u=").append(this.groupId);
        buf.append(";i=").append(this.entityId);
    }

    @Override
    protected void populateStringValue(StringBuilder buf) {
        buf.append("groupId=").append(this.groupId);
        buf.append(", entityId=").append(this.entityId);
    }

    @Override
    protected UserLongCompositePK clone() {
        return (UserLongCompositePK)super.clone();
    }

    public int hashCode() {
        return Objects.hash(this.groupId, this.entityId);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof LongIntegerCompositePK)) {
            return false;
        }
        LongIntegerCompositePK other = (LongIntegerCompositePK)obj;
        return Objects.equals(this.groupId, other.groupId) && Objects.equals(this.entityId, other.entityId);
    }

    public String ident() {
        return String.format("(%d,%d)", this.groupId, this.entityId);
    }

    public final Long getGroupId() {
        return this.groupId;
    }

    public final Integer getEntityId() {
        return this.entityId;
    }

    @Override
    public final Long keyComponent1() {
        return this.getGroupId();
    }

    @Override
    public final Integer keyComponent2() {
        return this.getEntityId();
    }

    @Override
    public final boolean keyComponentIsAssigned(int index) {
        if (index == 0) {
            return this.groupId != UNASSIGNED_GROUP_ID;
        }
        if (index == 1) {
            return this.entityId != UNASSIGNED_ENTITY_ID;
        }
        return CompositeKey2.super.keyComponentIsAssigned(index);
    }

    public final boolean groupIdIsAssigned() {
        return this.keyComponentIsAssigned(0);
    }

    public final boolean entityIdIsAssigned() {
        return this.keyComponentIsAssigned(1);
    }

    @Override
    public <T> T keyComponentValue(int index, Object val) {
        try {
            if (index == 0) {
                if (val == null) {
                    return (T)UNASSIGNED_GROUP_ID;
                }
                if (val instanceof Long) {
                    Long n = (Long)val;
                    return (T)n;
                }
                if (val instanceof Number) {
                    Number n = (Number)val;
                    return (T)Long.valueOf(n.longValue());
                }
                return (T)Long.valueOf(val.toString());
            }
            if (index == 1) {
                if (val == null) {
                    return (T)UNASSIGNED_ENTITY_ID;
                }
                if (val instanceof Integer) {
                    Integer n = (Integer)val;
                    return (T)n;
                }
                if (val instanceof Number) {
                    Number n = (Number)val;
                    return (T)Integer.valueOf(n.intValue());
                }
                return (T)Integer.valueOf(val.toString());
            }
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Key component %d does not support value %s.".formatted(index, val));
        }
        throw new IllegalArgumentException("Key component %d out of range.".formatted(index));
    }

    @Override
    public LongIntegerCompositePK createKey(CompositeKey template, Object ... components) {
        Object v1;
        Object object = components != null && components.length > 0 ? components[0] : (v1 = template != null ? template.keyComponent(0) : null);
        Object v2 = components != null && components.length > 1 ? components[1] : (template != null ? template.keyComponent(1) : null);
        Long k1 = v1 != null ? (Long)this.keyComponentValue(0, v1) : UNASSIGNED_GROUP_ID;
        Integer k2 = v2 != null ? (Integer)this.keyComponentValue(1, v2) : UNASSIGNED_ENTITY_ID;
        return new LongIntegerCompositePK(k1, k2);
    }
}

