/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.central.domain;

import java.util.Arrays;

public class LogEventInfo {
    private final String[] tags;
    private final String message;
    private final String data;

    public static LogEventInfo event(String[] baseTags, String message, String data, String ... extraTags) {
        boolean hasExtraTags;
        String[] tags = null;
        boolean hasBaseTags = baseTags != null && baseTags.length > 0;
        boolean bl = hasExtraTags = extraTags != null && extraTags.length > 0;
        if (hasBaseTags && hasExtraTags) {
            tags = new String[baseTags.length + extraTags.length];
            System.arraycopy(baseTags, 0, tags, 0, baseTags.length);
            System.arraycopy(extraTags, 0, tags, baseTags.length, extraTags.length);
        } else if (hasBaseTags) {
            tags = baseTags;
        } else if (hasExtraTags) {
            tags = extraTags;
        }
        return new LogEventInfo(tags, message, data);
    }

    public LogEventInfo(String[] tags, String message, String data) {
        this.tags = tags;
        this.message = message;
        this.data = data;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("LogEventInfo{");
        if (this.tags != null) {
            builder.append("tags=");
            builder.append(Arrays.toString(this.tags));
            builder.append(", ");
        }
        if (this.message != null) {
            builder.append("message=");
            builder.append(this.message);
            builder.append(", ");
        }
        if (this.data != null) {
            builder.append("data=");
            builder.append(this.data);
        }
        builder.append("}");
        return builder.toString();
    }

    public String[] getTags() {
        return this.tags;
    }

    public String getMessage() {
        return this.message;
    }

    public String getData() {
        return this.data;
    }
}

