/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.central.domain;

import java.io.Serializable;
import java.util.Objects;
import net.solarnetwork.central.domain.BasePK;
import net.solarnetwork.util.ObjectUtils;

public class KeyTypePK
extends BasePK
implements Cloneable,
Serializable,
Comparable<KeyTypePK> {
    private static final long serialVersionUID = -8662588990798009764L;
    private final String key;
    private final String type;

    public static KeyTypePK keyType(String key, String type) {
        return new KeyTypePK(key, type);
    }

    public KeyTypePK(String key, String type) {
        this.key = (String)ObjectUtils.requireNonNullArgument((Object)key, (String)"key");
        this.type = (String)ObjectUtils.requireNonNullArgument((Object)type, (String)"type");
    }

    @Override
    protected void populateIdValue(StringBuilder buf) {
        buf.append("k=");
        if (this.key != null) {
            buf.append(this.key);
        }
        buf.append(";t=");
        if (this.type != null) {
            buf.append(this.type);
        }
    }

    @Override
    protected void populateStringValue(StringBuilder buf) {
        if (this.key != null) {
            if (buf.length() > 0) {
                buf.append(", ");
            }
            buf.append("key=");
            buf.append(this.key);
        }
        if (this.type != null) {
            if (buf.length() > 0) {
                buf.append(", ");
            }
            buf.append("type=");
            buf.append(this.type);
        }
    }

    public int hashCode() {
        return Objects.hash(this.key, this.type);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KeyTypePK)) {
            return false;
        }
        KeyTypePK other = (KeyTypePK)obj;
        return Objects.equals(this.key, other.key) && Objects.equals(this.type, other.type);
    }

    @Override
    public int compareTo(KeyTypePK o) {
        if (o == null) {
            return 1;
        }
        int comparison = this.key.compareTo(o.key);
        if (comparison != 0) {
            return comparison;
        }
        return this.type.compareTo(o.type);
    }

    public String getKey() {
        return this.key;
    }

    public String getType() {
        return this.type;
    }
}

