/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.central.domain;

import java.time.Duration;
import java.time.Instant;
import net.solarnetwork.central.domain.ClaimableJobState;
import net.solarnetwork.dao.Entity;

public interface ClaimableJob<C, R, S extends ClaimableJobState, PK>
extends Entity<PK> {
    public C getConfiguration();

    public S getJobState();

    default public String getTokenId() {
        return null;
    }

    public String getGroupKey();

    public double getPercentComplete();

    public Instant getStarted();

    public Instant getCompleted();

    default public Duration getJobDuration() {
        Instant s = this.getStarted();
        Instant e = this.getCompleted();
        if (s != null && e != null) {
            return Duration.between(s, e);
        }
        if (s != null) {
            return Duration.between(s, Instant.now());
        }
        return Duration.ZERO;
    }

    public Boolean getJobSuccess();

    public String getMessage();

    public R getResult();
}

