/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.central.domain;

import java.io.Serializable;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.Objects;
import net.solarnetwork.central.domain.SolarNodeOwnership;
import net.solarnetwork.domain.Differentiable;
import net.solarnetwork.util.ObjectUtils;

public class BasicSolarNodeOwnership
implements Serializable,
SolarNodeOwnership,
Differentiable<SolarNodeOwnership> {
    private static final long serialVersionUID = 3442524641711956994L;
    private final Long nodeId;
    private final Long userId;
    private final String country;
    private final ZoneId zone;
    private final boolean requiresAuthorization;
    private final boolean archived;

    public static BasicSolarNodeOwnership ownershipFor(Long nodeId, Long userId) {
        return new BasicSolarNodeOwnership(nodeId, userId, null, ZoneOffset.UTC, false, false);
    }

    public static BasicSolarNodeOwnership ownershipFor(Long nodeId, Long userId, String country, String timeZoneId) {
        return new BasicSolarNodeOwnership(nodeId, userId, country, timeZoneId != null ? ZoneId.of(timeZoneId) : ZoneOffset.UTC, false, false);
    }

    public static BasicSolarNodeOwnership privateOwnershipFor(Long nodeId, Long userId) {
        return new BasicSolarNodeOwnership(nodeId, userId, null, ZoneOffset.UTC, true, false);
    }

    public static BasicSolarNodeOwnership privateOwnershipFor(Long nodeId, Long userId, String country, String timeZoneId) {
        return new BasicSolarNodeOwnership(nodeId, userId, country, timeZoneId != null ? ZoneId.of(timeZoneId) : ZoneOffset.UTC, true, false);
    }

    public BasicSolarNodeOwnership(Long nodeId, Long userId, String country, ZoneId zone, boolean requiresAuthorization, boolean archived) {
        this.nodeId = (Long)ObjectUtils.requireNonNullArgument((Object)nodeId, (String)"nodeId");
        this.userId = (Long)ObjectUtils.requireNonNullArgument((Object)userId, (String)"userId");
        this.country = country;
        this.zone = zone != null ? zone : ZoneOffset.UTC;
        this.requiresAuthorization = requiresAuthorization;
        this.archived = archived;
    }

    public boolean isSameAs(SolarNodeOwnership other) {
        if (other == null) {
            return false;
        }
        return Objects.equals(this.nodeId, other.getNodeId()) && Objects.equals(this.userId, other.getUserId()) && Objects.equals(this.country, other.getCountry()) && Objects.equals(this.zone, other.getZone()) && Objects.equals(this.requiresAuthorization, other.isRequiresAuthorization()) && Objects.equals(this.archived, other.isArchived());
    }

    public boolean differsFrom(SolarNodeOwnership other) {
        return !this.isSameAs(other);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("SolarNodeOwnership{");
        if (this.nodeId != null) {
            buf.append("nodeId=");
            buf.append(this.nodeId);
            buf.append(", ");
        }
        if (this.userId != null) {
            buf.append("userId=");
            buf.append(this.userId);
            buf.append(", ");
        }
        if (this.country != null) {
            buf.append("country=");
            buf.append(this.country);
            buf.append(", ");
        }
        buf.append("zone=").append(this.zone.getId()).append(", ");
        buf.append(this.requiresAuthorization ? "private" : "public");
        if (this.archived) {
            buf.append(", archived");
        }
        buf.append("}");
        return buf.toString();
    }

    public int hashCode() {
        return Objects.hash(this.nodeId);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof BasicSolarNodeOwnership)) {
            return false;
        }
        BasicSolarNodeOwnership other = (BasicSolarNodeOwnership)obj;
        return Objects.equals(this.nodeId, other.nodeId);
    }

    @Override
    public Long getNodeId() {
        return this.nodeId;
    }

    @Override
    public Long getUserId() {
        return this.userId;
    }

    @Override
    public String getCountry() {
        return this.country;
    }

    @Override
    public ZoneId getZone() {
        return this.zone;
    }

    @Override
    public boolean isRequiresAuthorization() {
        return this.requiresAuthorization || this.archived;
    }

    @Override
    public boolean isArchived() {
        return this.archived;
    }
}

