/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.central.domain;

import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.time.Instant;
import java.util.Objects;
import net.solarnetwork.central.dao.BaseUserModifiableEntity;
import net.solarnetwork.central.domain.UserStringCompositePK;
import net.solarnetwork.central.security.CertificateUtils;
import net.solarnetwork.service.CertificateException;
import net.solarnetwork.util.ObjectUtils;

public abstract class BaseUserCertificate<C extends BaseUserCertificate<C>>
extends BaseUserModifiableEntity<C, UserStringCompositePK> {
    private static final long serialVersionUID = -8325998663783331582L;
    private X509Certificate certificate;

    public BaseUserCertificate(UserStringCompositePK id, Instant created) {
        super((UserStringCompositePK)ObjectUtils.requireNonNullArgument((Object)id, (String)"id"), (Instant)ObjectUtils.requireNonNullArgument((Object)created, (String)"created"));
    }

    public BaseUserCertificate(Long userId, String subjectDn, Instant created) {
        super(new UserStringCompositePK(userId, subjectDn), created);
    }

    public BaseUserCertificate(Long userId, X509Certificate certificate, Instant created) {
        super(new UserStringCompositePK(userId, CertificateUtils.canonicalSubjectDn(certificate)), created);
        this.setCertificate(certificate);
    }

    @Override
    public void copyTo(C entity) {
        super.copyTo(entity);
        ((BaseUserCertificate)entity).setCertificate(this.certificate);
    }

    @Override
    public boolean isSameAs(C other) {
        return super.isSameAs(other) && Objects.equals(this.certificate, ((BaseUserCertificate)other).getCertificate());
    }

    public String getSubjectDn() {
        UserStringCompositePK pk = (UserStringCompositePK)this.getId();
        return pk != null ? pk.getEntityId() : null;
    }

    public X509Certificate getCertificate() {
        return this.certificate;
    }

    public void setCertificate(X509Certificate certificate) {
        this.certificate = certificate;
    }

    public Instant getExpires() {
        X509Certificate cert = this.getCertificate();
        if (cert == null) {
            return null;
        }
        return cert.getNotAfter().toInstant();
    }

    public byte[] certificateData() {
        X509Certificate cert = this.getCertificate();
        try {
            return cert != null ? cert.getEncoded() : null;
        }
        catch (CertificateEncodingException e) {
            throw new CertificateException((Throwable)e);
        }
    }
}

