/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.central.domain;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.io.Serializable;
import java.time.Instant;
import net.solarnetwork.central.domain.KeyTypePK;
import net.solarnetwork.dao.Entity;
import net.solarnetwork.domain.BasicIdentity;
import net.solarnetwork.util.ObjectUtils;

@JsonIgnoreProperties(value={"id"})
public class AppSetting
extends BasicIdentity<KeyTypePK>
implements Entity<KeyTypePK>,
Cloneable,
Serializable {
    private static final long serialVersionUID = -7907835439616081294L;
    private final Instant created;
    private final Instant modified;
    private final String value;

    public static AppSetting appSetting(String key, String type, String value) {
        return new AppSetting(key, type, null, null, value);
    }

    public AppSetting(KeyTypePK id, Instant created, Instant modified, String value) {
        super((Comparable)((KeyTypePK)ObjectUtils.requireNonNullArgument((Object)id, (String)"id")));
        this.created = created;
        this.modified = modified;
        this.value = value;
    }

    public AppSetting(String key, String type, Instant created, Instant modified, String value) {
        this(new KeyTypePK(key, type), created, modified, value);
    }

    public AppSetting withValue(String value) {
        return new AppSetting((KeyTypePK)this.getId(), this.getCreated(), Instant.now(), value);
    }

    public AppSetting clone() {
        return (AppSetting)super.clone();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("AppSetting{");
        if (this.getKey() != null) {
            builder.append("key=").append(this.getKey()).append(", ");
        }
        if (this.getType() != null) {
            builder.append("type=").append(this.getType()).append(", ");
        }
        if (this.value != null) {
            builder.append("value=").append(this.value).append(", ");
        }
        if (this.created != null) {
            builder.append("created=").append(this.created).append(", ");
        }
        if (this.modified != null) {
            builder.append("modified=").append(this.modified);
        }
        builder.append("}");
        return builder.toString();
    }

    public Instant getCreated() {
        return this.created;
    }

    public Instant getModified() {
        return this.modified;
    }

    public String getKey() {
        return ((KeyTypePK)this.getId()).getKey();
    }

    public String getType() {
        return ((KeyTypePK)this.getId()).getType();
    }

    public String getValue() {
        return this.value;
    }
}

