/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.central.domain;

import java.io.Serializable;
import java.time.Instant;
import java.util.Objects;
import net.solarnetwork.domain.BaseId;
import net.solarnetwork.domain.datum.Aggregation;
import net.solarnetwork.domain.datum.ObjectDatumKind;

public class AggregateDatumId
extends BaseId
implements Cloneable,
Serializable,
Comparable<AggregateDatumId> {
    private static final long serialVersionUID = 182649624035421355L;
    private final ObjectDatumKind kind;
    private final Long objectId;
    private final String sourceId;
    private final Instant timestamp;
    private final Aggregation aggregation;

    public static AggregateDatumId nodeId(Long nodeId, String sourceId, Instant timestamp, Aggregation aggregation) {
        return new AggregateDatumId(ObjectDatumKind.Node, nodeId, sourceId, timestamp, aggregation);
    }

    public static AggregateDatumId locationId(Long locationId, String sourceId, Instant timestamp, Aggregation aggregation) {
        return new AggregateDatumId(ObjectDatumKind.Location, locationId, sourceId, timestamp, aggregation);
    }

    public AggregateDatumId(ObjectDatumKind kind, Long objectId, String sourceId, Instant timestamp, Aggregation aggregation) {
        this.kind = kind;
        this.objectId = objectId;
        this.sourceId = sourceId;
        this.timestamp = timestamp;
        this.aggregation = aggregation;
    }

    public AggregateDatumId clone() {
        return (AggregateDatumId)super.clone();
    }

    protected void populateIdValue(StringBuilder buf) {
        buf.append("k=");
        if (this.kind != null) {
            buf.append(this.kind.getKey());
        }
        buf.append(";o=");
        if (this.objectId != null) {
            buf.append(this.objectId);
        }
        buf.append(";s=");
        if (this.sourceId != null) {
            buf.append(this.sourceId);
        }
        buf.append(";t=");
        if (this.timestamp != null) {
            buf.append(this.timestamp.getEpochSecond()).append('.').append(this.timestamp.getNano());
        }
        buf.append(";a=");
        if (this.aggregation != null) {
            buf.append(this.aggregation);
        }
    }

    protected void populateStringValue(StringBuilder buf) {
        if (this.kind != null) {
            if (buf.length() > 0) {
                buf.append(", ");
            }
            buf.append("kind=");
            buf.append(this.kind);
        }
        if (this.objectId != null) {
            if (buf.length() > 0) {
                buf.append(", ");
            }
            buf.append("objectId=");
            buf.append(this.objectId);
        }
        if (this.sourceId != null) {
            if (buf.length() > 0) {
                buf.append(", ");
            }
            buf.append("sourceId=");
            buf.append(this.sourceId);
        }
        if (this.timestamp != null) {
            if (buf.length() > 0) {
                buf.append(", ");
            }
            buf.append("timestamp=");
            buf.append(this.timestamp);
        }
        if (this.aggregation != null) {
            if (buf.length() > 0) {
                buf.append(", ");
            }
            buf.append("aggregation=");
            buf.append(this.aggregation);
        }
    }

    @Override
    public int compareTo(AggregateDatumId o) {
        if (this == o) {
            return 0;
        }
        if (o == null) {
            return -1;
        }
        int result = 0;
        if (this.kind != o.kind) {
            if (this.kind == null) {
                return 1;
            }
            if (o.kind == null) {
                return -1;
            }
            result = this.kind.compareTo((Enum)o.kind);
            if (result != 0) {
                return result;
            }
        }
        if (this.objectId != o.objectId) {
            if (this.objectId == null) {
                return 1;
            }
            if (o.objectId == null) {
                return -1;
            }
            result = this.objectId.compareTo(o.objectId);
            if (result != 0) {
                return result;
            }
        }
        if (this.sourceId != o.sourceId) {
            if (this.sourceId == null) {
                return 1;
            }
            if (o.sourceId == null) {
                return -1;
            }
            result = this.sourceId.compareTo(o.sourceId);
            if (result != 0) {
                return result;
            }
        }
        if (this.timestamp != o.timestamp) {
            if (this.timestamp == null) {
                return 1;
            }
            if (o.timestamp == null) {
                return -1;
            }
            result = this.timestamp.compareTo(o.timestamp);
            if (result != 0) {
                return result;
            }
        }
        if (this.aggregation == o.aggregation) {
            return 0;
        }
        if (this.aggregation == null) {
            return 1;
        }
        if (o.aggregation == null) {
            return -1;
        }
        return this.aggregation.compareTo((Enum)o.aggregation);
    }

    public int hashCode() {
        return Objects.hash(this.kind, this.objectId, this.sourceId, this.timestamp, this.aggregation);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AggregateDatumId)) {
            return false;
        }
        AggregateDatumId other = (AggregateDatumId)obj;
        return Objects.equals(this.kind, other.kind) && Objects.equals(this.objectId, other.objectId) && Objects.equals(this.sourceId, other.sourceId) && Objects.equals(this.timestamp, other.timestamp) && Objects.equals(this.aggregation, other.aggregation);
    }

    public boolean isValidObjectId(ObjectDatumKind expectedKind) {
        return expectedKind == this.kind && this.objectId != null && this.sourceId != null && !this.sourceId.isEmpty() && this.timestamp != null;
    }

    public boolean isValidAggregateObjectId(ObjectDatumKind expectedKind) {
        return this.isValidObjectId(this.kind) && this.aggregation != null;
    }

    public ObjectDatumKind getKind() {
        return this.kind;
    }

    public Long getObjectId() {
        return this.objectId;
    }

    public String getSourceId() {
        return this.sourceId;
    }

    public Instant getTimestamp() {
        return this.timestamp;
    }

    public Aggregation getAggregation() {
        return this.aggregation;
    }
}

