/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.central.dao.mybatis.type;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import net.solarnetwork.domain.CodedValue;
import net.solarnetwork.util.ObjectUtils;
import org.apache.ibatis.type.BaseTypeHandler;
import org.apache.ibatis.type.JdbcType;

public class CodedValueTypeHandler<E extends Enum<E>>
extends BaseTypeHandler<E> {
    private final Class<E> type;
    private final E[] values;
    private final E defaultValue;

    public CodedValueTypeHandler(Class<E> type) {
        this(type, null);
    }

    public CodedValueTypeHandler(Class<E> type, E defaultValue) {
        this.type = (Class)ObjectUtils.requireNonNullArgument(type, (String)"type");
        this.values = (Enum[])type.getEnumConstants();
        this.defaultValue = defaultValue;
    }

    public void setParameter(PreparedStatement ps, int i, E parameter, JdbcType jdbcType) throws SQLException {
        super.setParameter(ps, i, parameter == null && this.defaultValue != null ? this.defaultValue : parameter, jdbcType);
    }

    public void setNonNullParameter(PreparedStatement ps, int i, E parameter, JdbcType jdbcType) throws SQLException {
        ps.setInt(i, ((CodedValue)parameter).getCode());
    }

    public E getNullableResult(ResultSet rs, String columnName) throws SQLException {
        int code = rs.getInt(columnName);
        if (rs.wasNull()) {
            return this.defaultValue;
        }
        return (E)((Enum)CodedValue.forCodeValue((int)code, this.values, this.defaultValue));
    }

    public E getNullableResult(ResultSet rs, int columnIndex) throws SQLException {
        int code = rs.getInt(columnIndex);
        if (rs.wasNull()) {
            return this.defaultValue;
        }
        return (E)((Enum)CodedValue.forCodeValue((int)code, this.values, this.defaultValue));
    }

    public E getNullableResult(CallableStatement cs, int columnIndex) throws SQLException {
        int code = cs.getInt(columnIndex);
        if (cs.wasNull()) {
            return this.defaultValue;
        }
        return (E)((Enum)CodedValue.forCodeValue((int)code, this.values, this.defaultValue));
    }

    public Class<E> getType() {
        return this.type;
    }

    public static class Zero<E extends Enum<E>>
    extends CodedValueTypeHandler<E> {
        public Zero(Class<E> type) {
            super(type, (Enum)CodedValue.forCodeValue((int)0, (CodedValue[])((Enum[])type.getEnumConstants()), null));
        }
    }
}

