/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.central.dao.mybatis.type;

import java.sql.Array;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.ibatis.type.BaseTypeHandler;
import org.apache.ibatis.type.JdbcType;

public abstract class BaseArrayTypeHandler
extends BaseTypeHandler<Object[]> {
    protected final String elementJdbcType;

    public BaseArrayTypeHandler(String elementJdbcType) {
        this.elementJdbcType = elementJdbcType;
    }

    public void setNonNullParameter(PreparedStatement ps, int i, Object[] parameter, JdbcType jdbcType) throws SQLException {
        if (parameter == null) {
            ps.setNull(i, 2003);
        } else {
            Connection conn = ps.getConnection();
            Array loc = conn.createArrayOf(this.elementJdbcType, parameter);
            ps.setArray(i, loc);
            loc.free();
        }
    }

    private Object[] extractArray(Array array) throws SQLException {
        if (array == null) {
            return null;
        }
        Object[] result = (Object[])array.getArray();
        array.free();
        return result;
    }

    public Object[] getNullableResult(ResultSet rs, String columnName) throws SQLException {
        return this.extractArray(rs.getArray(columnName));
    }

    public Object[] getNullableResult(ResultSet rs, int columnIndex) throws SQLException {
        return this.extractArray(rs.getArray(columnIndex));
    }

    public Object[] getNullableResult(CallableStatement cs, int columnIndex) throws SQLException {
        return this.extractArray(cs.getArray(columnIndex));
    }
}

