/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.central.dao.mybatis.support;

import java.io.IOException;
import java.sql.SQLException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.sql.DataSource;
import net.solarnetwork.util.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.ConcurrencyFailureException;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.UncategorizedSQLException;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

public class MyBatisExceptionTranslator
extends org.mybatis.spring.MyBatisExceptionTranslator {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private MultiValueMap<String, SqlStateErrorConfig> sqlStateConfigurations;

    public MyBatisExceptionTranslator(DataSource dataSource, boolean exceptionTranslatorLazyInit) {
        super(dataSource, exceptionTranslatorLazyInit);
        if (!exceptionTranslatorLazyInit) {
            this.loadExceptionProperties();
        }
    }

    public DataAccessException translateExceptionIfPossible(RuntimeException e) {
        if (e != null && e.getCause() instanceof DataAccessException) {
            return (DataAccessException)e.getCause();
        }
        DataAccessException result = super.translateExceptionIfPossible(e);
        if (result instanceof UncategorizedSQLException || result == null) {
            SQLException sqlEx = null;
            for (Throwable t = e; t != null && sqlEx == null; t = t.getCause()) {
                if (t instanceof SQLException) {
                    sqlEx = (SQLException)t;
                    continue;
                }
                if (!(t instanceof UncategorizedSQLException)) continue;
                sqlEx = ((UncategorizedSQLException)t).getSQLException();
            }
            if (sqlEx != null) {
                List configs;
                String sqlState = sqlEx.getSQLState();
                String sqlMessage = sqlEx.getMessage();
                if (this.sqlStateConfigurations == null) {
                    this.loadExceptionProperties();
                }
                List list = configs = this.sqlStateConfigurations != null ? (List)this.sqlStateConfigurations.get((Object)sqlState) : null;
                if (configs != null) {
                    for (SqlStateErrorConfig config : configs) {
                        if (!config.messagePattern.matcher(sqlMessage).find()) continue;
                        result = config.type.toException(sqlEx, result);
                    }
                }
            }
        }
        return result;
    }

    private synchronized void loadExceptionProperties() {
        Properties props = new Properties();
        try {
            props.load(((Object)((Object)this)).getClass().getResourceAsStream("sql-error-matches.properties"));
        }
        catch (IOException | NullPointerException e) {
            this.log.warn("Error loading SQL error matches properties file: {}", (Object)e.toString());
        }
        this.sqlStateConfigurations = this.loadSqlStateProperties(props);
    }

    private synchronized MultiValueMap<String, SqlStateErrorConfig> loadSqlStateProperties(Properties props) {
        LinkedHashMap<String, Map> sqlStateMap = new LinkedHashMap<String, Map>(8);
        Pattern sqlStatePat = Pattern.compile("state\\.([^\\.]+)\\.([^\\\\.]+)\\.([^\\\\.]+)");
        for (Map.Entry<Object, Object> me : props.entrySet()) {
            String propKey = me.getKey().toString();
            Matcher m = sqlStatePat.matcher(propKey);
            if (!m.matches()) continue;
            String sqlState = m.group(1);
            String name = m.group(2);
            String prop = m.group(3);
            Map propMap = sqlStateMap.computeIfAbsent(name, k -> new LinkedHashMap());
            propMap.put("state", sqlState);
            propMap.put(prop, me.getValue().toString());
        }
        LinkedMultiValueMap result = new LinkedMultiValueMap(8);
        for (Map.Entry me : sqlStateMap.entrySet()) {
            String name = (String)me.getKey();
            Map configProps = (Map)me.getValue();
            try {
                SqlStateErrorConfig cfg = new SqlStateErrorConfig(name, (String)configProps.get("state"), (String)configProps.get("pat"), (String)configProps.get("type"));
                result.add((Object)cfg.sqlState, (Object)cfg);
            }
            catch (IllegalArgumentException e) {
                this.log.warn("SQL state error properties syntax error: {}", (Object)e.toString());
            }
        }
        return result;
    }

    private static class SqlStateErrorConfig {
        private final String name;
        private final String sqlState;
        private final Pattern messagePattern;
        private final ExceptionType type;

        private SqlStateErrorConfig(String name, String sqlState, String messagePattern, String type) {
            this.name = (String)ObjectUtils.requireNonNullArgument((Object)name, (String)"name");
            this.sqlState = (String)ObjectUtils.requireNonNullArgument((Object)sqlState, (String)"sqlState");
            if (messagePattern == null) {
                throw new IllegalArgumentException("The messagePattern argument must not be null.");
            }
            this.messagePattern = Pattern.compile(messagePattern, 2);
            if (type == null) {
                throw new IllegalArgumentException("The type argument must not be null.");
            }
            this.type = ExceptionType.valueOf(type);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("SqlStateErrorConfig{name=");
            builder.append(this.name);
            builder.append(", sqlState=");
            builder.append(this.sqlState);
            builder.append(", messagePattern=");
            builder.append(this.messagePattern);
            builder.append(", type=");
            builder.append((Object)this.type);
            builder.append("}");
            return builder.toString();
        }
    }

    private static enum ExceptionType {
        ConcurrencyFailure;


        private DataAccessException toException(Throwable t, DataAccessException fallback) {
            switch (this.ordinal()) {
                case 0: {
                    return new ConcurrencyFailureException(t.getMessage(), t);
                }
            }
            return fallback;
        }
    }
}

