/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.central.dao.mybatis.support;

import java.time.Instant;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.solarnetwork.central.dao.mybatis.support.BaseMyBatisDao;
import net.solarnetwork.dao.Entity;
import net.solarnetwork.dao.GenericDao;
import net.solarnetwork.domain.SortDescriptor;
import org.apache.ibatis.executor.BatchResult;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.PropertyAccessorFactory;

public abstract class BaseMyBatisGenericDaoSupport<T extends Entity<K>, K>
extends BaseMyBatisDao
implements GenericDao<T, K> {
    public static final int ERROR_CODE_INVALID_QUERY = 1101;
    public static final String QUERY_FOR_ID = "get-%s-for-id";
    public static final String QUERY_FOR_ALL = "findall-%s";
    public static final String INSERT_OBJECT = "insert-%s";
    public static final String UPDATE_OBJECT = "update-%s";
    public static final String DELETE_OBJECT = "delete-%s";
    public static final String SORT_DESCRIPTORS_PROPERTY = "SortDescriptors";
    public static final String FILTER_PROPERTY = "filter";
    private final Class<? extends T> objectType;
    private final Class<? extends K> keyType;
    private String queryForId;
    private String queryForAll;
    private String insert;
    private String update;
    private String delete;

    public BaseMyBatisGenericDaoSupport(Class<? extends T> objectType, Class<? extends K> keyType) {
        if (objectType == null) {
            throw new IllegalArgumentException("The objectType parameter must not be null.");
        }
        if (keyType == null) {
            throw new IllegalArgumentException("The keyType parameter must not be null.");
        }
        this.objectType = objectType;
        this.keyType = keyType;
        String domainName = objectType.getSimpleName();
        this.queryForId = String.format(QUERY_FOR_ID, domainName);
        this.queryForAll = String.format(QUERY_FOR_ALL, domainName);
        this.insert = String.format(INSERT_OBJECT, domainName);
        this.update = String.format(UPDATE_OBJECT, domainName);
        this.delete = String.format(DELETE_OBJECT, domainName);
    }

    public Class<? extends T> getObjectType() {
        return this.objectType;
    }

    public Class<? extends K> getKeyType() {
        return this.keyType;
    }

    public T get(K id) {
        return (T)((Entity)this.getSqlSession().selectOne(this.queryForId, id));
    }

    public Collection<T> getAll(List<SortDescriptor> sorts) {
        List results = sorts != null && sorts.size() > 0 ? this.getSqlSession().selectList(this.queryForAll, Collections.singletonMap(SORT_DESCRIPTORS_PROPERTY, sorts)) : this.getSqlSession().selectList(this.queryForAll);
        return results;
    }

    public K save(T entity) {
        if (this.isAssignedPrimaryKeys()) {
            return this.saveWithAssignedPrimaryKey(entity);
        }
        if (entity.hasId()) {
            return this.handleUpdate(entity);
        }
        this.preprocessInsert(entity);
        return this.handleInsert(entity);
    }

    protected K saveWithAssignedPrimaryKey(T entity) {
        int count = this.getLastUpdateCount(this.getSqlSession().update(this.getUpdate(), entity));
        if (count == 0) {
            this.preprocessInsert(entity);
            this.getSqlSession().insert(this.getInsert(), entity);
        }
        return (K)entity.getId();
    }

    protected int getLastUpdateCount(int count) {
        BatchResult br;
        int[] counts;
        List updates;
        if (count < 0 && (updates = this.getSqlSession().flushStatements()) != null && !updates.isEmpty() && (counts = (br = (BatchResult)updates.get(updates.size() - 1)).getUpdateCounts()) != null && counts.length > 0) {
            count = counts[counts.length - 1];
        }
        return count;
    }

    public void delete(T entity) {
        this.handleDelete(entity.getId());
    }

    protected int handleDelete(K id) {
        if (id == null) {
            return 0;
        }
        int result = this.getLastUpdateCount(this.getSqlSession().delete(this.delete, id));
        if (result < 1) {
            this.log.debug("Delete [{}] did not affect any rows.", id);
        } else if (this.log.isInfoEnabled()) {
            this.log.debug("Deleted [{}]", id);
        }
        return result;
    }

    protected void preprocessInsert(T entity) {
        BeanWrapper wrapper;
        if (entity.getCreated() == null && (wrapper = PropertyAccessorFactory.forBeanPropertyAccess(entity)).isWritableProperty("created")) {
            wrapper.setPropertyValue("created", (Object)Instant.now());
        }
    }

    protected K handleUpdate(T entity) {
        this.getSqlSession().update(this.update, entity);
        return (K)entity.getId();
    }

    protected K handleInsert(T entity) {
        int updated = this.getSqlSession().insert(this.insert, entity);
        this.log.debug("Insert of {} updated {} rows", entity, (Object)updated);
        return (K)entity.getId();
    }

    protected boolean isAssignedPrimaryKeys() {
        return false;
    }

    public String getQueryForId() {
        return this.queryForId;
    }

    public void setQueryForId(String queryForId) {
        this.queryForId = queryForId;
    }

    public String getQueryForAll() {
        return this.queryForAll;
    }

    public void setQueryForAll(String queryForAll) {
        this.queryForAll = queryForAll;
    }

    public String getInsert() {
        return this.insert;
    }

    public void setInsert(String insert) {
        this.insert = insert;
    }

    public void setUpdate(String update) {
        this.update = update;
    }

    public String getUpdate() {
        return this.update;
    }

    public String getDelete() {
        return this.delete;
    }

    public void setDelete(String delete) {
        this.delete = delete;
    }
}

