/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.central.dao.mybatis.support;

import java.io.Serializable;
import java.time.Instant;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.solarnetwork.central.ValidationException;
import net.solarnetwork.central.dao.GenericDao;
import net.solarnetwork.central.dao.mybatis.support.BaseMyBatisDao;
import net.solarnetwork.central.dao.mybatis.support.SqlSessionCallback;
import net.solarnetwork.dao.Entity;
import net.solarnetwork.domain.Identity;
import net.solarnetwork.domain.SortDescriptor;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.PropertyAccessorFactory;
import org.springframework.context.MessageSource;
import org.springframework.validation.BindException;
import org.springframework.validation.Errors;

public abstract class BaseMyBatisGenericDao<T extends Entity<PK>, PK extends Serializable>
extends BaseMyBatisDao
implements GenericDao<T, PK> {
    public static final int ERROR_CODE_INVALID_QUERY = 1101;
    public static final String QUERY_FOR_ID = "get-%s-for-id";
    public static final String QUERY_FOR_ALL = "findall-%s";
    public static final String INSERT_OBJECT = "insert-%s";
    public static final String UPDATE_OBJECT = "update-%s";
    public static final String DELETE_OBJECT = "delete-%s";
    public static final String SORT_DESCRIPTORS_PROPERTY = "SortDescriptors";
    public static final String ID_PROPERTY = "id";
    public static final String INDEX_PROPERTY = "index";
    public static final String BEAN_OBJECT_PROPERTY = "obj";
    public static final String DATE_PROPERTY = "date";
    public static final String RELATION_LIST_QUERY_FOR_PARENT = "findall-%s-";
    public static final String RELATION_OBJ_QUERY_FOR_PARENT = "get-%s-";
    public static final String RELATION_INSERT = "insert-%s-";
    public static final String RELATION_UPDATE = "update-%s-";
    public static final String RELATION_DELETE = "delete-%s-";
    public static final String CHILD_INSERT = "insert-";
    public static final String CHILD_UPDATE = "update-";
    public static final String CHILD_DELETE = "delete-";
    private final Class<? extends T> domainClass;
    private final Class<? extends PK> pkClass;
    private String queryForId;
    private String queryForAll;
    private String insert;
    private String update;
    private String delete;
    private String relationQueryForParent;
    private String relationObjectQueryForParent;
    private String relationInsert;
    private String relationUpdate;
    private String relationDelete;
    private String childInsert;
    private String childUpdate;
    private String childDelete;
    private MessageSource messageSource;

    public BaseMyBatisGenericDao(Class<? extends T> domainClass, Class<? extends PK> pkClass) {
        String domainName = domainClass.getSimpleName();
        this.domainClass = domainClass;
        this.pkClass = pkClass;
        this.queryForId = String.format(QUERY_FOR_ID, domainName);
        this.queryForAll = String.format(QUERY_FOR_ALL, domainName);
        this.insert = String.format(INSERT_OBJECT, domainName);
        this.update = String.format(UPDATE_OBJECT, domainName);
        this.delete = String.format(DELETE_OBJECT, domainName);
        this.relationQueryForParent = String.format(RELATION_LIST_QUERY_FOR_PARENT, domainName);
        this.relationObjectQueryForParent = String.format(RELATION_OBJ_QUERY_FOR_PARENT, domainName);
        this.relationInsert = String.format(RELATION_INSERT, domainName);
        this.relationUpdate = String.format(RELATION_UPDATE, domainName);
        this.relationDelete = String.format(RELATION_DELETE, domainName);
        this.childInsert = CHILD_INSERT;
        this.childUpdate = CHILD_UPDATE;
        this.childDelete = CHILD_DELETE;
    }

    @Override
    public Class<? extends T> getObjectType() {
        return this.domainClass;
    }

    public Class<? extends PK> getPrimaryKeyType() {
        return this.pkClass;
    }

    @Override
    public T get(PK id) {
        return (T)((Entity)this.getSqlSession().selectOne(this.queryForId, id));
    }

    @Override
    public List<T> getAll(List<SortDescriptor> sortDescriptors) {
        List results;
        if (sortDescriptors != null && sortDescriptors.size() > 0) {
            HashMap<String, List<SortDescriptor>> params = new HashMap<String, List<SortDescriptor>>(1);
            params.put(SORT_DESCRIPTORS_PROPERTY, sortDescriptors);
            results = this.getSqlSession().selectList(this.queryForAll, params);
        } else {
            results = this.getSqlSession().selectList(this.queryForAll);
        }
        return results;
    }

    @Override
    public PK store(T datum) {
        if (datum.getId() != null) {
            return this.handleUpdate(datum);
        }
        this.preprocessInsert(datum);
        return this.handleInsert(datum);
    }

    protected PK handleAssignedPrimaryKeyStore(T datum) {
        if (this.getSqlSession().update(this.getUpdate(), datum) == 0) {
            this.preprocessInsert(datum);
            this.getSqlSession().insert(this.getInsert(), datum);
        }
        return (PK)((Serializable)datum.getId());
    }

    protected void preprocessInsert(T datum) {
        if (datum.getCreated() == null) {
            BeanWrapper wrapper = PropertyAccessorFactory.forBeanPropertyAccess(datum);
            wrapper.setPropertyValue("created", (Object)Instant.now());
        }
    }

    protected PK handleUpdate(T datum) {
        this.getSqlSession().update(this.update, datum);
        return (PK)((Serializable)datum.getId());
    }

    protected PK handleInsert(T datum) {
        int updated = this.getSqlSession().insert(this.insert, datum);
        this.log.debug("Insert of {} updated {} rows", datum, (Object)updated);
        return (PK)((Serializable)datum.getId());
    }

    @Override
    public void delete(T domainObject) {
        if (domainObject.getId() == null) {
            return;
        }
        int result = this.getSqlSession().delete(this.delete, domainObject.getId());
        if (result < 1) {
            this.log.warn("Delete [" + String.valueOf(domainObject) + "] did not affect any rows");
        } else if (this.log.isInfoEnabled()) {
            this.log.debug("Deleted [" + String.valueOf(domainObject) + "]");
        }
    }

    protected <E> void handleRelation(Long parentId, List<E> newList, Class<? extends E> relationClass, Map<String, ?> additionalProperties) {
        if (parentId == null) {
            return;
        }
        String domainName = relationClass.getSimpleName();
        String findForParentQuery = this.relationQueryForParent + domainName;
        String deleteRelationQuery = this.relationDelete + domainName;
        List oldList = this.getSqlSession().selectList(findForParentQuery, (Object)parentId);
        HashMap<String, Object> sqlProperties = new HashMap<String, Object>(3 + (additionalProperties == null ? 0 : additionalProperties.size()));
        if (additionalProperties != null) {
            sqlProperties.putAll(additionalProperties);
        }
        sqlProperties.put(ID_PROPERTY, parentId);
        if (newList == null || newList.size() == 0) {
            if (oldList != null && oldList.size() > 0) {
                this.getSqlSession().delete(deleteRelationQuery, sqlProperties);
            }
        } else {
            Iterator oldItr;
            String insertRelationQuery = this.relationInsert + domainName;
            String updateRelationQuery = this.relationUpdate + domainName;
            int index = 0;
            Iterator<E> newItr = newList.iterator();
            Iterator iterator = oldItr = oldList == null ? null : oldList.iterator();
            while (newItr.hasNext()) {
                E newContact = newItr.next();
                Object oldContact = oldItr == null || !oldItr.hasNext() ? null : oldItr.next();
                sqlProperties.put(INDEX_PROPERTY, index);
                sqlProperties.put(BEAN_OBJECT_PROPERTY, newContact);
                if (oldContact == null) {
                    this.getSqlSession().insert(insertRelationQuery, sqlProperties);
                } else if (!newContact.equals(oldContact)) {
                    this.getSqlSession().update(updateRelationQuery, sqlProperties);
                }
                ++index;
            }
            while (oldItr != null && oldItr.hasNext()) {
                oldItr.next();
                sqlProperties.put(INDEX_PROPERTY, index);
                this.getSqlSession().delete(deleteRelationQuery, sqlProperties);
                ++index;
            }
        }
    }

    protected <E extends Identity<Long>> void handleRelation(Long parentId, E newObject, Class<? extends E> relationClass, Map<String, ?> additionalProperties) {
        if (parentId == null) {
            return;
        }
        String domainName = relationClass.getSimpleName();
        String findForParentQuery = this.relationObjectQueryForParent + domainName;
        Long oldObjectId = (Long)this.getSqlSession().selectOne(findForParentQuery, (Object)parentId);
        HashMap<String, Object> sqlProperties = new HashMap<String, Object>(2 + (additionalProperties == null ? 0 : additionalProperties.size()));
        if (additionalProperties != null) {
            sqlProperties.putAll(additionalProperties);
        }
        sqlProperties.put(ID_PROPERTY, parentId);
        sqlProperties.put(BEAN_OBJECT_PROPERTY, newObject);
        if (newObject == null) {
            if (oldObjectId != null) {
                String deleteRelationQuery = this.relationDelete + domainName;
                this.getSqlSession().delete(deleteRelationQuery, sqlProperties);
            }
        } else if (oldObjectId == null) {
            String insertRelationQuery = this.relationInsert + domainName;
            this.getSqlSession().insert(insertRelationQuery, sqlProperties);
        } else if (!oldObjectId.equals(newObject.getId())) {
            String updateRelationQuery = this.relationUpdate + domainName;
            this.getSqlSession().insert(updateRelationQuery, sqlProperties);
        }
    }

    protected <E extends Identity<Long>> Long handleChildRelation(T parent, E child, Class<? extends E> relationClass) {
        if (parent == null) {
            return null;
        }
        String domainName = relationClass.getSimpleName();
        String findForParentQuery = this.relationObjectQueryForParent + domainName;
        if (child == null) {
            Long oldObjectId = null;
            if (parent.getId() != null) {
                oldObjectId = (Long)this.getSqlSession().selectOne(findForParentQuery, parent.getId());
            }
            if (oldObjectId != null) {
                String deleteRelationQuery = this.childDelete + domainName;
                this.getSqlSession().delete(deleteRelationQuery, (Object)oldObjectId);
            }
            return null;
        }
        if (child.getId() == null) {
            String insertRelationQuery = this.childInsert + domainName;
            Integer childId = this.getSqlSession().insert(insertRelationQuery, child);
            if (childId instanceof Long) {
                return (Long)((Object)childId);
            }
            return null;
        }
        String updateRelationQuery = this.childUpdate + domainName;
        this.getSqlSession().insert(updateRelationQuery, child);
        return (Long)child.getId();
    }

    protected <R> R execute(SqlSessionCallback<R> callback, Object errorObject) {
        try {
            return callback.doWithSqlSession(this.getSqlSession());
        }
        catch (RuntimeException e) {
            throw this.mapSqlMapException(e, errorObject);
        }
    }

    protected RuntimeException mapSqlMapException(RuntimeException e, Object errorObject) {
        RuntimeException result = e;
        BindException errors = new BindException(errorObject, "filter");
        if (e.getMessage().contains("no statement named")) {
            errors.reject("error.unknown.query", "Unknown query");
        }
        if (errors.hasErrors()) {
            result = new ValidationException((Errors)errors, this.getMessageSource(), e);
        }
        return result;
    }

    protected String getMemberDomainKey(Class<?> memberClass) {
        return memberClass.getSimpleName();
    }

    protected final boolean spaceAppend(String value, StringBuilder buf) {
        if (value == null) {
            return false;
        }
        if ((value = value.trim()).length() < 1) {
            return false;
        }
        if (buf.length() > 0) {
            buf.append(' ');
        }
        buf.append(value);
        return true;
    }

    public String getQueryForId() {
        return this.queryForId;
    }

    public void setQueryForId(String queryForId) {
        this.queryForId = queryForId;
    }

    public String getInsert() {
        return this.insert;
    }

    public void setInsert(String insert) {
        this.insert = insert;
    }

    public String getUpdate() {
        return this.update;
    }

    public void setUpdate(String update) {
        this.update = update;
    }

    public Class<? extends T> getDomainClass() {
        return this.domainClass;
    }

    public String getQueryForAll() {
        return this.queryForAll;
    }

    public void setQueryForAll(String queryForAll) {
        this.queryForAll = queryForAll;
    }

    public String getDelete() {
        return this.delete;
    }

    public void setDelete(String delete) {
        this.delete = delete;
    }

    public String getRelationQueryForParent() {
        return this.relationQueryForParent;
    }

    public void setRelationQueryForParent(String relationQueryForParent) {
        this.relationQueryForParent = relationQueryForParent;
    }

    public String getRelationInsert() {
        return this.relationInsert;
    }

    public void setRelationInsert(String relationInsert) {
        this.relationInsert = relationInsert;
    }

    public String getRelationUpdate() {
        return this.relationUpdate;
    }

    public void setRelationUpdate(String relationUpdate) {
        this.relationUpdate = relationUpdate;
    }

    public String getRelationDelete() {
        return this.relationDelete;
    }

    public void setRelationDelete(String relationDelete) {
        this.relationDelete = relationDelete;
    }

    public String getRelationObjectQueryForParent() {
        return this.relationObjectQueryForParent;
    }

    public void setRelationObjectQueryForParent(String relationObjectQueryForParent) {
        this.relationObjectQueryForParent = relationObjectQueryForParent;
    }

    public String getChildInsert() {
        return this.childInsert;
    }

    public void setChildInsert(String childInsert) {
        this.childInsert = childInsert;
    }

    public String getChildUpdate() {
        return this.childUpdate;
    }

    public void setChildUpdate(String childUpdate) {
        this.childUpdate = childUpdate;
    }

    public String getChildDelete() {
        return this.childDelete;
    }

    public void setChildDelete(String childDelete) {
        this.childDelete = childDelete;
    }

    public MessageSource getMessageSource() {
        return this.messageSource;
    }

    public void setMessageSource(MessageSource messageSource) {
        this.messageSource = messageSource;
    }
}

