/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.central.dao.mybatis.support;

import java.util.List;
import java.util.Map;
import net.solarnetwork.central.dao.mybatis.support.BaseMyBatisGenericDaoSupport;
import net.solarnetwork.central.dao.mybatis.support.FilterResultsFactory;
import net.solarnetwork.dao.BasicFilterResults;
import net.solarnetwork.dao.Entity;
import net.solarnetwork.dao.FilterResults;
import net.solarnetwork.dao.FilterableDao;
import net.solarnetwork.dao.PaginationCriteria;
import net.solarnetwork.domain.Identity;
import net.solarnetwork.domain.SortDescriptor;

public abstract class BaseMyBatisFilterableDaoSupport<T extends Entity<K>, K, M extends Identity<K>, F extends PaginationCriteria>
extends BaseMyBatisGenericDaoSupport<T, K>
implements FilterableDao<M, K, F>,
FilterResultsFactory<M, K, F> {
    private final Class<? extends M> matchType;

    public BaseMyBatisFilterableDaoSupport(Class<? extends T> objectType, Class<? extends K> keyType, Class<? extends M> matchType) {
        super(objectType, keyType);
        this.matchType = matchType;
    }

    protected String getFilteredQuery(String filterDomain, F filter) {
        return this.getQueryForAll() + "-" + filterDomain;
    }

    protected void postProcessFilterProperties(F filter, Map<String, Object> sqlProps) {
    }

    protected FilterResults<M, K> doFindFiltered(F filter, List<SortDescriptor> sorts, Integer offset, Integer max) {
        String filterDomain = this.matchType.getSimpleName();
        String query = this.getFilteredQuery(filterDomain, filter);
        return this.selectFiltered(query, filter, sorts, offset, max, this::postProcessFilterProperties, this);
    }

    @Override
    public FilterResults<M, K> createFilterResults(F filter, Map<String, Object> sqlProps, Iterable<M> rows, Long totalCount, Integer offset, Integer returnedCount) {
        return BasicFilterResults.filterResults(rows, filter, (Long)totalCount, (int)(returnedCount != null ? returnedCount : 0));
    }
}

