/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.central.dao.mybatis.support;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.solarnetwork.central.dao.FilterableDao;
import net.solarnetwork.central.dao.mybatis.support.BaseMyBatisGenericDao;
import net.solarnetwork.central.domain.Filter;
import net.solarnetwork.central.domain.FilterMatch;
import net.solarnetwork.central.domain.FilterResults;
import net.solarnetwork.central.support.BasicFilterResults;
import net.solarnetwork.dao.Entity;
import net.solarnetwork.domain.SortDescriptor;

public abstract class BaseMyBatisFilterableDao<T extends Entity<PK>, M extends FilterMatch<PK>, F extends Filter, PK extends Serializable>
extends BaseMyBatisGenericDao<T, PK>
implements FilterableDao<M, PK, F> {
    public static final String FILTER_PROPERTY = "filter";
    private final Class<? extends M> filterResultClass;

    public BaseMyBatisFilterableDao(Class<? extends T> domainClass, Class<? extends PK> pkClass, Class<? extends M> filterResultClass) {
        super(domainClass, pkClass);
        this.filterResultClass = filterResultClass;
    }

    protected String getFilteredQuery(String filterDomain, F filter) {
        return this.getQueryForAll() + "-" + filterDomain;
    }

    protected void postProcessFilterProperties(F filter, Map<String, Object> sqlProps) {
    }

    @Override
    public FilterResults<M> findFiltered(F filter, List<SortDescriptor> sortDescriptors, Integer offset, Integer max) {
        Long n;
        String filterDomain = this.getMemberDomainKey(this.filterResultClass);
        String query = this.getFilteredQuery(filterDomain, filter);
        HashMap<String, Object> sqlProps = new HashMap<String, Object>(1);
        sqlProps.put(FILTER_PROPERTY, filter);
        if (sortDescriptors != null && sortDescriptors.size() > 0) {
            sqlProps.put("SortDescriptors", sortDescriptors);
        }
        this.postProcessFilterProperties(filter, sqlProps);
        Long totalCount = null;
        if (max != null && max != -1 && (n = this.executeFilterCountQuery(query + "-count", filter, sqlProps)) != null) {
            totalCount = (long)n;
        }
        List rows = this.selectList(query, sqlProps, offset, max);
        BasicFilterResults results = new BasicFilterResults(rows, totalCount != null ? totalCount : Long.valueOf(rows.size()), offset, rows.size());
        return results;
    }

    protected Long executeFilterCountQuery(String countQueryName, F filter, Map<String, ?> sqlProps) {
        try {
            return this.selectLong(countQueryName, sqlProps);
        }
        catch (RuntimeException e) {
            Throwable cause = e;
            while (cause.getCause() != null) {
                cause = cause.getCause();
            }
            if (!(cause instanceof IllegalArgumentException)) {
                throw e;
            }
            this.log.warn("Count query not supported: {}", (Object)countQueryName, (Object)e);
            return null;
        }
    }
}

