/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.central.dao.mybatis.support;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import net.solarnetwork.central.dao.mybatis.support.FilterResultsFactory;
import net.solarnetwork.central.dao.mybatis.support.MyBatisExceptionTranslator;
import net.solarnetwork.dao.BasicFilterResults;
import net.solarnetwork.dao.FilterResults;
import net.solarnetwork.dao.OptimizedQueryCriteria;
import net.solarnetwork.dao.PaginationCriteria;
import net.solarnetwork.dao.SortCriteria;
import net.solarnetwork.domain.Identity;
import net.solarnetwork.domain.SortDescriptor;
import org.apache.ibatis.session.RowBounds;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionTemplate;
import org.mybatis.spring.support.SqlSessionDaoSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.support.PersistenceExceptionTranslator;

public abstract class BaseMyBatisDao
extends SqlSessionDaoSupport {
    public static final RowBounds FIRST_ROW = new RowBounds(0, 1);
    public static final String FILTER_PROPERTY = "filter";
    public static final String SORT_DESCRIPTORS_PROPERTY = "SortDescriptors";
    protected final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    public void setSqlSessionFactory(SqlSessionFactory sqlSessionFactory) {
        if (this.getSqlSession() == null) {
            this.setSqlSessionTemplate(new SqlSessionTemplate(sqlSessionFactory, sqlSessionFactory.getConfiguration().getDefaultExecutorType(), (PersistenceExceptionTranslator)new MyBatisExceptionTranslator(sqlSessionFactory.getConfiguration().getEnvironment().getDataSource(), true)));
        }
        super.setSqlSessionFactory(sqlSessionFactory);
    }

    protected final <E> E selectFirst(String statement, Object parameters) {
        List results = this.getSqlSession().selectList(statement, parameters, FIRST_ROW);
        if (results.size() > 0) {
            return results.get(0);
        }
        return null;
    }

    protected final <E> List<E> selectList(String statement, Object parameters, Integer offset, Integer max) {
        List rows = null;
        rows = max != null && max > 0 ? this.getSqlSession().selectList(statement, parameters, new RowBounds(offset == null || offset < 0 ? 0 : offset, max.intValue())) : this.getSqlSession().selectList(statement, parameters);
        return rows;
    }

    protected Long selectLong(String statement, Object parameters) {
        Number n = (Number)this.getSqlSession().selectOne(statement, parameters);
        if (n != null) {
            return n.longValue();
        }
        return null;
    }

    protected Long executeCountQuery(String countQueryName, Map<String, ?> sqlProps) {
        try {
            return this.selectLong(countQueryName, sqlProps);
        }
        catch (RuntimeException e) {
            Throwable cause = e;
            while (cause.getCause() != null) {
                cause = cause.getCause();
            }
            if (!(cause instanceof IllegalArgumentException)) {
                throw e;
            }
            this.log.warn("Count query not supported: {}", (Object)countQueryName, (Object)e);
            return null;
        }
    }

    protected <M extends Identity<K>, K, F> FilterResults<M, K> selectFiltered(String query, F filter) {
        return this.selectFiltered(query, filter, null, null, null, null, null);
    }

    protected <M extends Identity<K>, K, F> FilterResults<M, K> selectFiltered(String query, F filter, List<SortDescriptor> sorts, Integer offset, Integer max) {
        return this.selectFiltered(query, filter, sorts, offset, max, null, null);
    }

    protected <M extends Identity<K>, K, F> FilterResults<M, K> selectFiltered(String query, F filter, List<SortDescriptor> sorts, Integer offset, Integer max, BiConsumer<F, Map<String, Object>> propertyProcessor) {
        return this.selectFiltered(query, filter, sorts, offset, max, propertyProcessor, null);
    }

    protected <M extends Identity<K>, K, F> FilterResults<M, K> selectFiltered(String query, F filter, List<SortDescriptor> sorts, Integer offset, Integer max, BiConsumer<F, Map<String, Object>> propertyProcessor, FilterResultsFactory<M, K, F> resultsFactory) {
        Long n;
        PaginationCriteria pagination;
        HashMap<String, Object> sqlProps = new HashMap<String, Object>(1);
        sqlProps.put(FILTER_PROPERTY, filter);
        if (filter instanceof SortCriteria && ((SortCriteria)filter).getSorts() != null && !((SortCriteria)filter).getSorts().isEmpty()) {
            sqlProps.put(SORT_DESCRIPTORS_PROPERTY, ((SortCriteria)filter).getSorts());
        } else if (sorts != null && sorts.size() > 0) {
            sqlProps.put(SORT_DESCRIPTORS_PROPERTY, sorts);
        }
        if (propertyProcessor != null) {
            propertyProcessor.accept(filter, sqlProps);
        }
        Integer m = max;
        Integer o = offset;
        if (filter instanceof PaginationCriteria && (pagination = (PaginationCriteria)filter).getMax() != null && pagination.getMax() > 0 && pagination.getOffset() != null && pagination.getOffset() >= 0) {
            max = pagination.getMax();
            m = null;
            offset = pagination.getOffset();
            o = null;
        }
        Long totalCount = null;
        if (!(max == null || max == -1 || filter instanceof OptimizedQueryCriteria && ((OptimizedQueryCriteria)filter).isWithoutTotalResultsCount() || (n = this.executeCountQuery(query + "-count", sqlProps)) == null)) {
            totalCount = (long)n;
        }
        List rows = this.selectList(query, sqlProps, o, m);
        if (resultsFactory != null) {
            return resultsFactory.createFilterResults(filter, sqlProps, rows, totalCount, offset, rows.size());
        }
        return new BasicFilterResults(rows, totalCount, offset != null ? offset : 0, rows.size());
    }
}

