/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.central.dao.mybatis;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.solarnetwork.central.dao.SolarNodeDao;
import net.solarnetwork.central.dao.mybatis.support.BaseMyBatisFilterableDao;
import net.solarnetwork.central.domain.FilterResults;
import net.solarnetwork.central.domain.SolarNode;
import net.solarnetwork.central.domain.SolarNodeFilter;
import net.solarnetwork.central.domain.SolarNodeFilterMatch;
import net.solarnetwork.central.domain.SolarNodeMatch;
import net.solarnetwork.central.support.BasicFilterResults;
import net.solarnetwork.codec.JsonUtils;
import net.solarnetwork.domain.SortDescriptor;
import net.solarnetwork.util.MapPathMatcher;
import net.solarnetwork.util.SearchFilter;

public class MyBatisSolarNodeDao
extends BaseMyBatisFilterableDao<SolarNode, SolarNodeFilterMatch, SolarNodeFilter, Long>
implements SolarNodeDao {
    public static final String QUERY_FOR_NEXT_NODE_ID = "get-next-node-id";

    public MyBatisSolarNodeDao() {
        super(SolarNode.class, Long.class, SolarNodeMatch.class);
    }

    @Override
    public Long getUnusedNodeId() {
        return (Long)this.getSqlSession().selectOne(QUERY_FOR_NEXT_NODE_ID);
    }

    @Override
    public Long store(SolarNode datum) {
        if (datum.getId() != null) {
            SolarNode entity = (SolarNode)this.get(datum.getId());
            if (entity == null) {
                this.preprocessInsert(datum);
                this.getSqlSession().insert(this.getInsert(), (Object)datum);
            } else {
                this.getSqlSession().update(this.getUpdate(), (Object)datum);
            }
            return datum.getId();
        }
        Long id = this.getUnusedNodeId();
        datum.setId(id);
        this.preprocessInsert(datum);
        this.getSqlSession().insert(this.getInsert(), (Object)datum);
        return id;
    }

    @Override
    public FilterResults<SolarNodeFilterMatch> findFiltered(SolarNodeFilter filter, List<SortDescriptor> sortDescriptors, Integer offset, Integer max) {
        String filterDomain = this.getMemberDomainKey(SolarNodeMatch.class);
        String query = this.getFilteredQuery(filterDomain, filter);
        HashMap<String, Object> sqlProps = new HashMap<String, Object>(1);
        sqlProps.put("filter", filter);
        if (sortDescriptors != null && sortDescriptors.size() > 0) {
            sqlProps.put("SortDescriptors", sortDescriptors);
        }
        List<Object> rows = this.selectList(query, sqlProps, null, null);
        SearchFilter sf = SearchFilter.forLDAPSearchFilterString((String)filter.getMetadataFilter());
        if (sf != null) {
            rows = rows.stream().filter(m -> {
                Map map = JsonUtils.getStringMap((String)m.getMetaJson());
                return map != null && MapPathMatcher.matches((Map)map, (SearchFilter)sf);
            }).collect(Collectors.toList());
        }
        return new BasicFilterResults<SolarNodeFilterMatch>(rows, Long.valueOf(rows.size()), offset, rows.size());
    }
}

