/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.central.dao.mybatis;

import java.util.HashMap;
import java.util.Map;
import net.solarnetwork.central.dao.SolarLocationDao;
import net.solarnetwork.central.dao.mybatis.support.BaseMyBatisFilterableDao;
import net.solarnetwork.central.domain.Location;
import net.solarnetwork.central.domain.LocationMatch;
import net.solarnetwork.central.domain.SolarLocation;

public class MyBatisSolarLocationDao
extends BaseMyBatisFilterableDao<SolarLocation, LocationMatch, Location, Long>
implements SolarLocationDao {
    public static final String QUERY_FOR_COUNTRY_TIME_ZONE = "find-SolarLocation-for-country-timezone";
    public static final String QUERY_FOR_EXACT_LOCATION = "find-SolarLocation-for-location";
    public static final String QUERY_FOR_NODE = "find-SolarLocation-for-node";

    public MyBatisSolarLocationDao() {
        super(SolarLocation.class, Long.class, LocationMatch.class);
    }

    @Override
    public Long store(SolarLocation datum) {
        if (this.log.isTraceEnabled()) {
            try {
                throw new RuntimeException("Storing solar location: " + String.valueOf(datum));
            }
            catch (Exception e) {
                this.log.trace("Storing solar location {} with data {}", new Object[]{datum, datum.getFilter(), e});
            }
        }
        return (Long)super.store(datum);
    }

    @Override
    public SolarLocation getSolarLocationForTimeZone(String country, String timeZoneId) {
        HashMap<String, String> params = new HashMap<String, String>(2);
        params.put("country", country);
        params.put("timeZoneId", timeZoneId);
        return (SolarLocation)this.selectFirst(QUERY_FOR_COUNTRY_TIME_ZONE, params);
    }

    @Override
    public SolarLocation getSolarLocationForLocation(Location criteria) {
        return (SolarLocation)this.selectFirst(QUERY_FOR_EXACT_LOCATION, criteria);
    }

    @Override
    protected void postProcessFilterProperties(Location filter, Map<String, Object> sqlProps) {
        StringBuilder fts = new StringBuilder();
        this.spaceAppend(filter.getName(), fts);
        this.spaceAppend(filter.getCountry(), fts);
        this.spaceAppend(filter.getRegion(), fts);
        this.spaceAppend(filter.getStateOrProvince(), fts);
        this.spaceAppend(filter.getLocality(), fts);
        this.spaceAppend(filter.getPostalCode(), fts);
        if (fts.length() > 0) {
            sqlProps.put("fts", fts.toString());
        }
    }

    @Override
    public SolarLocation getSolarLocationForNode(Long nodeId) {
        return (SolarLocation)this.selectFirst(QUERY_FOR_NODE, nodeId);
    }
}

