/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.central.dao;

import java.util.List;
import java.util.concurrent.Executor;
import javax.cache.Cache;
import net.solarnetwork.central.common.dao.CachingGenericDao;
import net.solarnetwork.central.dao.UserMetadataDao;
import net.solarnetwork.central.domain.UserMetadataEntity;
import net.solarnetwork.central.domain.UserMetadataFilter;
import net.solarnetwork.central.domain.UserStringCompositePK;
import net.solarnetwork.dao.FilterResults;
import net.solarnetwork.domain.SortDescriptor;
import net.solarnetwork.util.ObjectUtils;

public class CachingUserMetadataDao
extends CachingGenericDao<UserMetadataEntity, Long, UserMetadataDao>
implements UserMetadataDao {
    private final Cache<UserStringCompositePK, String> metadataPathCache;

    public CachingUserMetadataDao(UserMetadataDao delegate, Cache<Long, UserMetadataEntity> cache, Executor executor, Cache<UserStringCompositePK, String> metadataPathCache) {
        super(delegate, cache, executor);
        this.metadataPathCache = (Cache)ObjectUtils.requireNonNullArgument(metadataPathCache, (String)"metadataPathCache");
    }

    public FilterResults<UserMetadataEntity, Long> findFiltered(UserMetadataFilter filter, List<SortDescriptor> sorts, Integer offset, Integer max) {
        return ((UserMetadataDao)this.delegate).findFiltered(filter, sorts, offset, max);
    }

    @Override
    public String jsonMetadataAtPath(Long userId, String path) {
        UserStringCompositePK key = new UserStringCompositePK(userId, path);
        String result = (String)this.metadataPathCache.get((Object)key);
        if (result == null && (result = ((UserMetadataDao)this.delegate).jsonMetadataAtPath(userId, path)) != null) {
            this.metadataPathCache.put((Object)key, (Object)result);
        }
        return result;
    }
}

